/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.TIntObjectHashMap;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.variables.IntVar;

public class TuplesVeryLargeTable
extends LargeRelation {
    private final int n;
    private final boolean feasible;
    private final TIntObjectHashMap<TIntObjectHashMap> supports;

    public TuplesVeryLargeTable(Tuples tuples, IntVar[] vars) {
        this.n = vars.length;
        this.feasible = tuples.isFeasible();
        this.supports = new TIntObjectHashMap();
        int nt = tuples.nbTuples();
        for (int i = 0; i < nt; ++i) {
            int[] tuple = tuples.get(i);
            if (!this.valid(tuple, vars)) continue;
            this.setTuple(tuple);
        }
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        TIntObjectHashMap current = this.supports;
        int i = 0;
        while (i < this.n - 1) {
            if ((current = current.get(tuple[i++])) != null) continue;
            return false;
        }
        return (current = current.get(tuple[i])) != null;
    }

    @Override
    public boolean isConsistent(int[] tuple) {
        return this.checkTuple(tuple) == this.feasible;
    }

    private void setTuple(int[] tuple) {
        TIntObjectHashMap current = this.supports;
        for (int i = 0; i < tuple.length; ++i) {
            TIntObjectHashMap _current = current.get(tuple[i]);
            if (_current == null) {
                _current = new TIntObjectHashMap();
                current.put(tuple[i], _current);
            }
            current = _current;
        }
    }

    @Override
    public Tuples convert() {
        Tuples tuples = new Tuples(this.feasible);
        int[] tt = new int[this.n];
        this.tuple(this.supports, tt, 0, tuples);
        return tuples;
    }

    private void tuple(TIntObjectHashMap<TIntObjectHashMap> current, int[] tt, int p, Tuples tuples) {
        if (current.isEmpty()) {
            tuples.add(tt);
        } else {
            int[] nArray = current.keys();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int k;
                tt[p] = k = nArray[i];
                this.tuple(current.get(k), tt, p + 1, tuples);
            }
        }
    }
}

