## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(spect)

## -----------------------------------------------------------------------------
set.seed(42)

data(pbc, package = "survival")

event_column <- "event_indicator"
time_column <- "survival_time"

pbc_complete <- pbc[complete.cases(pbc),]
source_data <- pbc_complete[,c(7:20)]
source_data[[event_column]] <- ifelse(pbc_complete$status == 2, 1, 0)
source_data[[time_column]] <- pbc_complete$time / 365.25

head(source_data)

## -----------------------------------------------------------------------------

predict_data <- source_data[1:10,]
train_data <- source_data[11:nrow(source_data),]

## -----------------------------------------------------------------------------
result <- spect_train(model_algorithm = "rf"
                      , base_learner_list = c("glm", "svmLinear")
                      , use_parallel = FALSE
                      , modeling_data = train_data
                      , event_indicator_var = event_column
                      , survival_time_var = time_column
                      , obs_window = 12)

## -----------------------------------------------------------------------------

plot_survival_curve(result, individual_id=40)


## -----------------------------------------------------------------------------

plot_survival_curve(result, individual_id=40, curve_type="conditional")


## -----------------------------------------------------------------------------

plot_survival_curve(result, individual_id=40, curve_type="absolute")


## -----------------------------------------------------------------------------

km_data <- plot_km(result, prediction_threshold_search_granularity = 0.1)

## -----------------------------------------------------------------------------

prediction_times = c(2, 6)
eval <- evaluate_model(result, prediction_times)

## -----------------------------------------------------------------------------

predictions  <- spect_predict(result, new_data=predict_data) 

# Collect the absolute probability of individual 1 surviving to time 6.
individual = 1
survival_time_check = 6

tail(predictions[predictions$individual_id == individual & predictions$upper_bound 
                    < survival_time_check,], n = 1)$abs_event_prob

