/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.iterations.IterativeProcess;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;

public class JacobiTransformation
extends IterativeProcess {
    double[][] rows;
    double[][] transform;
    int p;
    int q;

    public JacobiTransformation(SymmetricMatrix symmetricMatrix) {
        int n = symmetricMatrix.rows();
        this.rows = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.rows[i][j] = symmetricMatrix.components[i][j];
            }
        }
    }

    public double[] eigenvalues() {
        int n = this.rows.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.rows[i][i];
        }
        return dArray;
    }

    public Vector[] eigenvectors() {
        int n = this.rows.length;
        Vector[] vectorArray = new Vector[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j] = this.transform[j][i];
            }
            vectorArray[i] = new Vector(dArray);
        }
        return vectorArray;
    }

    @Override
    public double evaluateIteration() {
        double d = this.largestOffDiagonal();
        this.transform();
        return d;
    }

    private void exchange(int n) {
        int n2 = n + 1;
        double d = this.rows[n][n];
        this.rows[n][n] = this.rows[n2][n2];
        this.rows[n2][n2] = d;
        int n3 = this.rows.length;
        for (int i = 0; i < n3; ++i) {
            d = this.transform[i][n];
            this.transform[i][n] = this.transform[i][n2];
            this.transform[i][n2] = d;
        }
    }

    @Override
    public void finalizeIterations() {
        int n = this.rows.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = -1;
            for (int i = 0; i < n2; ++i) {
                if (!(Math.abs(this.rows[i][i]) < Math.abs(this.rows[i + 1][i + 1]))) continue;
                this.exchange(i);
                n3 = i;
            }
            n2 = n3;
        }
    }

    @Override
    public void initializeIterations() {
        this.transform = SymmetricMatrix.identityMatrix((int)this.rows.length).components;
    }

    private double largestOffDiagonal() {
        double d = 0.0;
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double d2 = Math.abs(this.rows[i][j]);
                if (!(d2 > d)) continue;
                d = d2;
                this.p = i;
                this.q = j;
            }
        }
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'[', ' '};
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            cArray[0] = 123;
            for (int j = 0; j <= i; ++j) {
                stringBuffer.append(cArray);
                stringBuffer.append(this.rows[i][j]);
                cArray[0] = 32;
            }
            stringBuffer.append('}');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private void transform() {
        double d = this.rows[this.p][this.q];
        if (d == 0.0) {
            return;
        }
        double d2 = this.rows[this.q][this.q];
        double d3 = this.rows[this.p][this.p];
        double d4 = (d2 - d3) * 0.5 / d;
        double d5 = d4 > 0.0 ? 1.0 / (Math.sqrt(d4 * d4 + 1.0) + d4) : 1.0 / (d4 - Math.sqrt(d4 * d4 + 1.0));
        double d6 = 1.0 / Math.sqrt(d5 * d5 + 1.0);
        double d7 = d5 * d6;
        double d8 = d7 / (1.0 + d6);
        this.rows[this.p][this.p] = d3 - d5 * d;
        this.rows[this.q][this.q] = d2 + d5 * d;
        this.rows[this.p][this.q] = 0.0;
        this.rows[this.q][this.p] = 0.0;
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            if (i != this.p && i != this.q) {
                this.rows[this.p][i] = this.rows[i][this.p] - d7 * (this.rows[i][this.q] + d8 * this.rows[i][this.p]);
                this.rows[this.q][i] = this.rows[i][this.q] + d7 * (this.rows[i][this.p] - d8 * this.rows[i][this.q]);
                this.rows[i][this.p] = this.rows[this.p][i];
                this.rows[i][this.q] = this.rows[this.q][i];
            }
            d4 = this.transform[i][this.p];
            d2 = this.transform[i][this.q];
            this.transform[i][this.p] = d4 - d7 * (d2 + d8 * d4);
            this.transform[i][this.q] = d2 + d7 * (d4 - d8 * d2);
        }
    }
}

