/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node;

import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyAlphaCut;

public abstract class Node {
    public static final int NVariable = 0;
    public static final int NLabel = 1;
    public static final int NConsequent = 2;
    public static final int NAnd = 3;
    public static final int NOr = 4;
    public static final int NEs = 5;
    public static final int NRule = 6;
    public static final int NRuleBase = 7;
    public static final int NExprHold = 8;
    public static final int NExprArit = 9;
    public static final int NValue = 10;
    public static final int NSum = 11;
    public static final int NMinus = 12;
    public static final int NProduct = 13;
    public static final int NSquareRoot = 14;
    public static final int NExp = 15;
    public static final int NLog = 16;
    protected int mytypeid;
    protected Node[] children;

    public Node[] children() {
        return this.children;
    }

    public Node(int t) {
        this.mytypeid = t;
        this.children = new Node[0];
    }

    public Node(int n, int t) {
        this.mytypeid = t;
        this.children = new Node[n];
    }

    public Node(Node n) {
        this.mytypeid = n.mytypeid;
        this.children = new Node[n.children.length];
    }

    public abstract Node clone();

    public void set(Node n) {
        this.mytypeid = n.mytypeid;
        this.children = new Node[n.children.length];
    }

    public void replaceTerminals(FuzzyAlphaCut[] x) {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].replaceTerminals(x);
        }
    }

    public abstract void debug();

    public abstract String output();

    public int type() {
        return this.mytypeid;
    }

    public int nChildren() {
        return this.children.length;
    }

    public Node child(int i) {
        return this.children[i];
    }

    public void changeChild(Node n, int i) {
        this.children[i] = n;
    }

    protected boolean compatibleData(Node n) {
        return this.mytypeid == n.mytypeid;
    }

    public boolean compatible(Node n) {
        if (!this.compatibleData(n)) {
            return false;
        }
        if (this.children.length != n.children.length) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].compatible(n.children[i])) continue;
            return false;
        }
        return true;
    }
}

