/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

public class Distributions {
    private static double logSqrtPi = Math.log(Math.sqrt(Math.PI));
    private static double rezSqrtPi = 1.0 / Math.sqrt(Math.PI);
    private static double bigx = 20.0;

    public static double binomialStandardError(double p, int n) {
        if (n == 0) {
            return 0.0;
        }
        return Math.sqrt(p * (1.0 - p) / (double)n);
    }

    public static double chiSquaredProbability(double x, int df) {
        double s;
        boolean even;
        double y = 0.0;
        if (x <= 0.0 || df < 1) {
            return 1.0;
        }
        double a = 0.5 * x;
        boolean bl = even = 2 * (df / 2) == df;
        if (df > 1) {
            y = Math.exp(-a);
        }
        double d = s = even ? y : 2.0 * Distributions.normalProbability(-Math.sqrt(x));
        if (df > 2) {
            double z;
            x = 0.5 * ((double)df - 1.0);
            double d2 = z = even ? 1.0 : 0.5;
            if (a > bigx) {
                double e = even ? 0.0 : logSqrtPi;
                double c = Math.log(a);
                while (z <= x) {
                    e = Math.log(z) + e;
                    double val = c * z - a - e;
                    s += Math.exp(val);
                    z += 1.0;
                }
                return s;
            }
            double e = even ? 1.0 : rezSqrtPi / Math.sqrt(a);
            double c = 0.0;
            while (z <= x) {
                c += (e *= a / z);
                z += 1.0;
            }
            return c * y + s;
        }
        return s;
    }

    public static double FCriticalValue(double p, int df1, int df2) {
        double maxf = 99999.0;
        double minf = 1.0E-6;
        if (p <= 0.0 || p >= 1.0) {
            return 0.0;
        }
        double fval = 1.0 / p;
        while (Math.abs(maxf - minf) > 1.0E-6) {
            if (Distributions.FProbability(fval, df1, df2) < p) {
                maxf = fval;
            } else {
                minf = fval;
            }
            fval = (maxf + minf) * 0.5;
        }
        return fval;
    }

    public static double FProbability(double F, int df1, int df2) {
        int j;
        double d;
        double y;
        double p;
        if (Math.abs(F) < 1.0E-9 || df1 <= 0 || df2 <= 0) {
            return 1.0;
        }
        int a = df1 % 2 == 1 ? 1 : 2;
        int b = df2 % 2 == 1 ? 1 : 2;
        double w = F * (double)df1 / (double)df2;
        double z = 1.0 / (1.0 + w);
        if (a == 1) {
            if (b == 1) {
                p = Math.sqrt(w);
                y = 0.3183098861837907;
                d = y * z / p;
                p = 2.0 * y * Math.atan(p);
            } else {
                p = Math.sqrt(w * z);
                d = 0.5 * p * z / w;
            }
        } else if (b == 1) {
            p = Math.sqrt(z);
            d = 0.5 * z * p;
            p = 1.0 - p;
        } else {
            d = z * z;
            p = w * z;
        }
        y = 2.0 * w / z;
        for (j = b + 2; j <= df2; j += 2) {
            p = a == 1 ? p + (d *= (1.0 + (double)a / ((double)j - 2.0)) * z) * y / ((double)j - 1.0) : (p + w) * z;
        }
        y = w * z;
        z = 2.0 / z;
        b = df2 - 2;
        for (int i = a + 2; i <= df1; i += 2) {
            j = i + b;
            p -= z * (d *= y * (double)j / ((double)i - 2.0)) / (double)j;
        }
        if (p < 0.0) {
            p = 0.0;
        } else if (p > 1.0) {
            p = 1.0;
        }
        return 1.0 - p;
    }

    public static double normalProbability(double z) {
        double x;
        if (z == 0.0) {
            x = 0.0;
        } else {
            double y = 0.5 * Math.abs(z);
            if (y >= 3.0) {
                x = 1.0;
            } else if (y < 1.0) {
                double w = y * y;
                x = ((((((((1.24818987E-4 * w - 0.001075204047) * w + 0.005198775019) * w - 0.019198292004) * w + 0.059054035642) * w - 0.151968751364) * w + 0.319152932694) * w - 0.5319230073) * w + 0.797884560593) * y * 2.0;
            } else {
                x = (((((((((((((-4.5255659E-5 * (y -= 2.0) + 1.5252929E-4) * y - 1.9538132E-5) * y - 6.76904986E-4) * y + 0.001390604284) * y - 7.9462082E-4) * y - 0.002034254874) * y + 0.006549791214) * y - 0.010557625006) * y + 0.011630447319) * y - 0.009279453341) * y + 0.005353579108) * y - 0.002141268741) * y + 5.35310849E-4) * y + 0.999936657524;
            }
        }
        return z > 0.0 ? (x + 1.0) / 2.0 : (1.0 - x) / 2.0;
    }

    public static double studentTConfidenceInterval(int df, double p, double se) {
        return Math.sqrt(Distributions.FCriticalValue(p, 1, df)) * se;
    }

    public static void main(String[] ops) {
        System.out.println("Binomial standard error (0.5, 100): " + Distributions.binomialStandardError(0.5, 100));
        System.out.println("Chi-squared probability (2.558, 10): " + Distributions.chiSquaredProbability(2.558, 10));
        System.out.println("Normal probability (0.2): " + Distributions.normalProbability(0.2));
        System.out.println("F critical value (0.05, 4, 5): " + Distributions.FCriticalValue(0.05, 4, 5));
        System.out.println("F probability (5.1922, 4, 5): " + Distributions.FProbability(5.1922, 4, 5));
        System.out.println("Student-t confidence interval (9, 0.01, 2): " + Distributions.studentTConfidenceInterval(9, 0.01, 2.0));
    }
}

