/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.R;

import eu.kliegr.ac1.R.Rinterface;
import eu.kliegr.ac1.rule.CBARuleComparator;
import eu.kliegr.ac1.rule.extend.DefaultRuleOverlapPruningType;
import eu.kliegr.ac1.rule.extend.ExtendRule;
import eu.kliegr.ac1.rule.extend.ExtendRuleConfig;
import eu.kliegr.ac1.rule.extend.ExtendRules;
import eu.kliegr.ac1.rule.extend.ExtendType;
import eu.kliegr.ac1.rule.extend.ExtensionStrategyEnum;
import eu.kliegr.ac1.rule.extend.PostPruningType;
import eu.kliegr.ac1.rule.parsers.GUHASimplifiedParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.logging.Logger;

public class RinterfaceExtend
extends Rinterface {
    private static final Logger LOGGER = Logger.getLogger(RinterfaceExtend.class.getName());
    boolean isContinuousPruningEnabled = false;
    boolean isFuzzificationEnabled = false;
    PostPruningType postpruningtype;
    boolean isAnnotationEnabled = true;
    Comparator ruleComparator = new CBARuleComparator();
    ExtendRuleConfig conf;
    ExtendRules extendRulesObj;

    public RinterfaceExtend(String[] att_types, String targetColName, String IDcolumnName, String loglevel) throws Exception {
        super(att_types, targetColName, IDcolumnName, loglevel);
    }

    public void extend(String extendType, String defaultRuleOverlapPruningType, boolean isAttPruningEnabled, boolean isTrimmingEnabled, boolean isContinuousPruningEnabled, String postpruningTypeStr, boolean isFuzzificationEnabled, boolean isAnnotationEnabled, double minImprovement, double minCondImprovement, double minConf, String extensionStrategy) throws Exception {
        this.isFuzzificationEnabled = isFuzzificationEnabled;
        this.postpruningtype = PostPruningType.valueOf(postpruningTypeStr);
        this.isContinuousPruningEnabled = isContinuousPruningEnabled;
        this.isAnnotationEnabled = isAnnotationEnabled;
        if (this.extendRulesObj != null) {
            throw new Exception("Rules already extended");
        }
        if (this.data.getDataTable() == null) {
            throw new Exception("Load data first");
        }
        if (this.rules == null) {
            throw new Exception("Load rules first");
        }
        this.conf = new ExtendRuleConfig(minImprovement, minCondImprovement, minConf, ExtensionStrategyEnum.valueOf(extensionStrategy));
        this.extendRulesObj = new ExtendRules(this.rules, this.ruleComparator, ExtendType.valueOf(extendType), this.conf, this.data);
        this.extendRulesObj.sortRules();
        try {
            this.extendRulesObj.processRules(isAttPruningEnabled, isTrimmingEnabled, isContinuousPruningEnabled, isFuzzificationEnabled, this.postpruningtype, DefaultRuleOverlapPruningType.valueOf(defaultRuleOverlapPruningType));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warning("There was exception, removing all results.");
            this.extendRulesObj = null;
            throw new Exception(e);
        }
        if (isAnnotationEnabled) {
            this.extendRulesObj.annotateRules();
        }
        LOGGER.info("Extend completed");
    }

    public void annotate() throws Exception {
        if (this.extendRulesObj == null) {
            throw new Exception("Rules must be first extended");
        }
        this.extendRulesObj.annotateRules();
    }

    public void saveToFile(String path) throws Exception {
        if (this.extendRulesObj == null) {
            throw new Exception("Rules must be first extended");
        }
        GUHASimplifiedParser.saveRules(this.extendRulesObj.getExtendedRules(), path);
    }

    public int getRuleCount() throws Exception {
        int ruleCount = this.extendRulesObj.getExtendedRules().size();
        return ruleCount;
    }

    public String[][] getRules_ExtendedStats() throws Exception {
        if (this.isAnnotationEnabled | this.isFuzzificationEnabled) {
            throw new Exception("Fuzzified or annotated rules cannot be exported to R, use saveToFile()!");
        }
        int ruleCount = this.extendRulesObj.getExtendedRules().size();
        String[][] df = new String[ruleCount][5];
        int i = 0;
        for (ExtendRule r : this.extendRulesObj.getExtendedRules()) {
            df[i][0] = r.getRule().getRuleAsArulesString();
            df[i][1] = Double.toString(r.getRuleQuality().getRelativeSupport());
            df[i][2] = Double.toString(r.getRuleQuality().getConfidence());
            df[i][4] = Double.toString(r.getQualityInRuleList().getSupport());
            df[i++][3] = Double.toString(r.getQualityInRuleList().getConfidence());
        }
        return df;
    }

    public String[][] getRulesBasicStats() throws Exception {
        if (this.isAnnotationEnabled | this.isFuzzificationEnabled) {
            throw new Exception("Fuzzified or annotated rules cannot be exported to R, use saveToFile()!");
        }
        int ruleCount = this.extendRulesObj.getExtendedRules().size();
        String[][] df = new String[ruleCount][3];
        int i = 0;
        for (ExtendRule r : this.extendRulesObj.getExtendedRules()) {
            df[i][0] = r.getRule().getRuleAsArulesString();
            df[i][1] = Double.toString(r.getRuleQuality().getRelativeSupport());
            df[i++][2] = Double.toString(r.getRuleQuality().getConfidence());
        }
        return df;
    }

    public String[][] getRulesBasicStatsLength() throws Exception {
        if (this.isAnnotationEnabled | this.isFuzzificationEnabled) {
            throw new Exception("Fuzzified or annotated rules cannot be exported to R, use saveToFile()!");
        }
        int ruleCount = this.extendRulesObj.getExtendedRules().size();
        String[][] df = new String[ruleCount][4];
        int i = 0;
        for (ExtendRule r : this.extendRulesObj.getExtendedRules()) {
            df[i][0] = r.getRule().getRuleAsArulesString();
            df[i][1] = Double.toString(r.getRuleQuality().getRelativeSupport());
            df[i][2] = Double.toString(r.getRuleQuality().getConfidence());
            df[i++][3] = Double.toString(r.getAntecedentLength());
        }
        return df;
    }

    public String[][] getRuleHistory() throws Exception {
        int ruleCount = this.extendRulesObj.getExtendedRules().size();
        ArrayList<String[]> histories = new ArrayList<String[]>();
        int totalHistorySize = 0;
        int columns = this.extendRulesObj.getExtendedRules().get(0).copyHistory().historyTableHeader().length;
        for (int i = 0; i < ruleCount; ++i) {
            Collection<String[]> curHistory = this.extendRulesObj.getExtendedRules().get(i).copyHistory().toCollection();
            totalHistorySize += curHistory.size();
            histories.addAll(curHistory);
        }
        String[][] result = new String[totalHistorySize][columns];
        int i = 0;
        for (String[] ch : histories) {
            result[i++] = ch;
        }
        return result;
    }
}

