/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearsystem;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.normalizer.SafeNormalizer;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderWithPivoting;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;

public class QRLinearSystemSolver
implements LinearSystemSolver {
    public static final QRLinearSystemSolver DEFAULT = QRLinearSystemSolver.builder().build();
    private final QRDecomposition.Decomposer decomposer;
    private final double eps;
    private final boolean normalize;

    public static Builder builder() {
        return new Builder();
    }

    private QRLinearSystemSolver(QRDecomposition.Decomposer decomposer, double eps, boolean normalize) {
        this.decomposer = decomposer;
        this.eps = eps;
        this.normalize = normalize;
    }

    @Override
    public void solve(FastMatrix A, DataBlock b) {
        QRDecomposition qr;
        int rank;
        FastMatrix An;
        if (this.normalize) {
            An = A.deepClone();
            DataBlockIterator rows = An.rowsIterator();
            SafeNormalizer sn = new SafeNormalizer();
            int i = 0;
            while (rows.hasNext()) {
                double fac = sn.normalize(rows.next());
                b.mul(i++, fac);
            }
        } else {
            An = A;
        }
        if ((rank = UpperTriangularMatrix.rank((qr = this.decomposer.decompose(An)).rawR(), this.eps)) != An.getRowsCount()) {
            throw new MatrixException("m_err_sing");
        }
        double[] y = b.toArray();
        qr.applyQt(y);
        UpperTriangularMatrix.solveUx(qr.rawR(), DataBlock.of(y));
        int[] pivot = qr.pivot();
        if (pivot == null) {
            b.copyFrom(y, 0);
        } else {
            for (int i = 0; i < rank; ++i) {
                b.set(pivot[i], y[i]);
            }
        }
    }

    @Override
    public void solve(FastMatrix A, FastMatrix B) {
        QRDecomposition qr;
        int rank;
        double[] factor = null;
        if (this.normalize) {
            An = A.deepClone();
            DataBlockIterator rows = An.rowsIterator();
            SafeNormalizer sn = new SafeNormalizer();
            factor = new double[A.getRowsCount()];
            int i = 0;
            while (rows.hasNext()) {
                factor[i++] = sn.normalize(rows.next());
            }
        } else {
            An = A;
        }
        if ((rank = UpperTriangularMatrix.rank((qr = this.decomposer.decompose(A)).rawR(), this.eps)) != A.getRowsCount()) {
            throw new MatrixException("m_err_sing");
        }
        DataBlockIterator cols = B.columnsIterator();
        while (cols.hasNext()) {
            DataBlock b = cols.next();
            double[] y = b.toArray();
            qr.applyQt(y);
            UpperTriangularMatrix.solveUx(qr.rawR(), DataBlock.of(y));
            int[] pivot = qr.pivot();
            if (pivot == null) {
                b.copyFrom(y, 0);
                continue;
            }
            for (int i = 0; i < rank; ++i) {
                b.set(pivot[i], y[i]);
            }
        }
        if (factor != null) {
            DataBlockIterator rows = B.rowsIterator();
            int r = 0;
            while (rows.hasNext()) {
                rows.next().div(factor[r++]);
            }
        }
    }

    public static class Builder {
        private QRDecomposition.Decomposer decomposer = A -> new HouseholderWithPivoting().decompose(A, 0);
        private double eps = 1.0E-13;
        private boolean normalize = false;

        private Builder() {
        }

        public Builder decomposer(QRDecomposition.Decomposer decomposer) {
            this.decomposer = decomposer;
            return this;
        }

        public Builder normalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public QRLinearSystemSolver build() {
            return new QRLinearSystemSolver(this.decomposer, this.eps, this.normalize);
        }
    }
}

