/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IArmaModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ArmaModule
implements IArmaModule {
    static final double NO_BIC = 99999.0;
    static final int NMOD = 5;
    private RegArmaBic[] estimations;
    private final int nmod;
    private final boolean balanced;
    private final boolean mixed;
    private final boolean wn;
    private final double eps;
    private final int maxP;
    private final int maxQ;
    private final int maxBp;
    private final int maxBq;

    static Builder builder() {
        return new Builder();
    }

    public SarmaOrders process(DoubleSeq data, int period, int d, int bd, boolean seas) {
        return this.select(data, period, d, bd);
    }

    public SarimaOrders process(RegArimaModel<SarimaModel> regarima, boolean seas) {
        SarimaOrders curSpec = ((SarimaModel)regarima.arima()).orders();
        DoubleSeq res = RegArimaUtility.olsResiduals(regarima);
        SarmaOrders nspec = this.select(res, curSpec.getPeriod(), curSpec.getD(), curSpec.getBd());
        if (nspec == null) {
            curSpec.setDefault(seas);
            return curSpec;
        }
        SarimaOrders rspec = SarimaOrders.of((SarmaOrders)nspec, (int)curSpec.getD(), (int)curSpec.getBd());
        return rspec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling context) {
        ProcessingLog log = context.getLog();
        log.push("arma selection");
        try {
            ModelDescription desc = context.getDescription();
            SarimaOrders curspec = desc.specification();
            DoubleSeq res = RegArimaUtility.olsResiduals((RegArimaModel)desc.regarima());
            SarmaOrders rsltSpec = this.select(res, desc.getAnnualFrequency(), curspec.getD(), curspec.getBd());
            log.info("selected model: " + rsltSpec.toString(), (Object)new CInfo(this.estimations, rsltSpec));
            if (rsltSpec.equals((Object)curspec.doStationary())) {
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            curspec = SarimaOrders.of((SarmaOrders)rsltSpec, (int)curspec.getD(), (int)curspec.getBd());
            desc.setSpecification(curspec);
            ProcessingResult processingResult = ProcessingResult.Changed;
            return processingResult;
        }
        catch (RuntimeException ex) {
            log.remark("arma selection failed");
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            log.pop();
        }
    }

    private ArmaModule(Builder builder) {
        this.nmod = builder.modelsCount;
        this.maxP = builder.maxP;
        this.maxQ = builder.maxQ;
        this.maxBp = builder.maxBp;
        this.maxBq = builder.maxBq;
        this.balanced = builder.balanced;
        this.mixed = builder.mixed;
        this.wn = builder.wn;
        this.eps = builder.eps;
    }

    public void clear() {
        this.estimations = null;
    }

    public int getCount() {
        return this.estimations == null ? 0 : this.estimations.length;
    }

    public RegArmaBic[] getPreferedModels() {
        return this.estimations;
    }

    public SarmaOrders select(DoubleSeq data, int d, int bd) {
        int idmax = this.nmod;
        while (this.estimations[idmax - 1].getBIC() == 99999.0) {
            --idmax;
        }
        SarmaOrders spec = this.estimations[0].getSpecification();
        int nr1 = spec.getP() + spec.getQ();
        int ns1 = spec.getBp() + spec.getBq();
        int nrr1 = Math.abs(spec.getP() + d - spec.getQ());
        int nss1 = Math.abs(spec.getBp() + bd - spec.getBq());
        double bmax = this.estimations[idmax - 1].getBIC() - this.estimations[0].getBIC();
        bmax = bmax < 0.003 ? 0.0625 : (bmax < 0.03 ? 0.25 : 1.0);
        double vc11 = 0.01 * bmax;
        double vc2 = 0.0025 * bmax;
        double vc22 = 0.0075 * bmax;
        int idpref = 0;
        int icmod = 0;
        for (int i = 1; i < idmax; ++i) {
            SarmaOrders cur = this.estimations[i].getSpecification();
            int nr2 = cur.getP() + cur.getQ();
            int ns2 = cur.getBp() + cur.getBq();
            int nrr2 = Math.abs(cur.getP() + d - cur.getQ());
            int nss2 = Math.abs(cur.getBp() + bd - cur.getBq());
            double dbic = this.estimations[i].getBIC() - this.estimations[idpref].getBIC();
            int chk = 0;
            if ((nrr2 < nrr1 || nss2 < nss1) && nr1 == nr2 && ns1 == ns2 && dbic <= vc11 && this.balanced) {
                chk = 1;
            } else if (nrr2 < nrr1 && nr2 <= nr1 && ns2 == ns1 && dbic <= vc2 && cur.getP() > 0 && cur.getQ() > 0 && this.balanced) {
                chk = 2;
            } else if ((nrr2 == 0 && nrr2 < nrr1 && d > 0 || nss2 == 0 && nss2 < nss1 && bd > 0) && nr1 == nr2 && ns1 == ns2 && dbic <= vc11 && this.balanced) {
                chk = 3;
            } else if (nrr2 == 0 && nss2 == 0 && dbic < vc2 && this.balanced) {
                chk = 4;
            } else if (nr2 > nr1 && nrr2 == 0 && ns2 == ns1 && dbic < vc2 && this.balanced) {
                chk = 5;
            } else if (ns2 > ns1 && nss2 == 0 && nr2 == nr1 && dbic < vc2 && this.balanced) {
                chk = 6;
            } else if (ns2 < ns1 && ns2 > 0 && nr2 == nr1 && nss2 == 0 && dbic < vc2 && this.balanced) {
                chk = 7;
            } else if (i == 1 && nr1 == 0 && nr2 == 1 && ns2 == ns1 && dbic < vc2) {
                chk = 8;
            } else if (nr2 < nr1 && nr2 > 0 && ns2 == ns1 && dbic < vc2) {
                chk = 9;
            } else if (ns2 < ns1 && ns2 > 0 && nr2 == nr1 && dbic < vc2) {
                chk = 10;
            } else if (cur.getP() < spec.getP() && cur.getQ() == spec.getQ() && nr2 > 0 && ns2 == ns1 && dbic < vc22) {
                chk = 11;
            }
            if (chk <= 0) continue;
            ++icmod;
            double dc = this.estimations[i].getBIC() - this.estimations[0].getBIC();
            vc11 -= dc;
            vc2 -= dc;
            vc22 -= dc;
            nr1 = nr2;
            ns1 = ns2;
            nrr1 = nrr2;
            nss1 = nss2;
            idpref = i;
            spec = cur.clone();
        }
        if (spec.getParametersCount() == 0 && idpref < this.nmod - 1) {
            return this.estimations[idpref + 1].getSpecification().clone();
        }
        return this.estimations[idpref].getSpecification().clone();
    }

    public SarmaOrders select(DoubleSeq data, int freq, int d, int bd) {
        this.clear();
        SarmaOrders spec = new SarmaOrders(freq);
        SarmaOrders cur = null;
        this.estimations = new RegArmaBic[this.nmod];
        if (freq == 2) {
            spec.setP(1);
        } else {
            spec.setP(3);
        }
        spec.setQ(0);
        boolean nmax = false;
        ArrayList<SarmaOrders> lspecs0 = new ArrayList<SarmaOrders>();
        if (freq != 1) {
            boolean i = false;
            for (int bp = 0; bp <= this.maxBp; ++bp) {
                for (int bq = 0; bq <= this.maxBq; ++bq) {
                    if (!this.mixed && bp != 0 && bq != 0) continue;
                    spec.setBp(bp);
                    spec.setBq(bq);
                    lspecs0.add(spec.clone());
                }
            }
            SarmaOrders[] specs0 = lspecs0.toArray(new SarmaOrders[lspecs0.size()]);
            RegArmaBic[] bic0 = RegArmaBic.sort(data, specs0, this.eps);
            if (bic0.length == 0) {
                return null;
            }
            cur = bic0[0].getSpecification().clone();
        } else {
            cur = spec.clone();
        }
        ArrayList<SarmaOrders> lspecs1 = new ArrayList<SarmaOrders>();
        boolean i = false;
        for (int p = 0; p <= this.maxP; ++p) {
            for (int q = 0; q <= this.maxQ; ++q) {
                if (!this.mixed && p != 0 && q != 0) continue;
                cur.setP(p);
                cur.setQ(q);
                lspecs1.add(cur.clone());
            }
        }
        SarmaOrders[] specs1 = lspecs1.toArray(new SarmaOrders[lspecs1.size()]);
        RegArmaBic[] bic1 = RegArmaBic.sort(data, specs1, this.eps);
        if (bic1.length == 0) {
            return null;
        }
        cur = bic1[0].getSpecification().clone();
        RegArmaBic.mergeInto(bic1, this.estimations);
        int spmax = this.maxBp;
        int sqmax = this.maxBq;
        if (bd == 1) {
            spmax = 0;
        }
        if (freq != 1) {
            ArrayList<SarmaOrders> lspecs2 = new ArrayList<SarmaOrders>();
            boolean i2 = false;
            for (int bp = 0; bp <= spmax; ++bp) {
                for (int bq = 0; bq <= sqmax; ++bq) {
                    if (!this.mixed && bp != 0 && bq != 0) continue;
                    cur.setBp(bp);
                    cur.setBq(bq);
                    lspecs2.add(cur.clone());
                }
            }
            SarmaOrders[] specs2 = lspecs2.toArray(new SarmaOrders[lspecs2.size()]);
            RegArmaBic[] bic2 = RegArmaBic.sort(data, specs2, this.eps);
            if (bic2.length == 0) {
                return null;
            }
            RegArmaBic.mergeInto(bic2, this.estimations);
        }
        if (freq == 1) {
            if (this.estimations[0].getSpecification().getParametersCount() == 0) {
                return this.estimations[1].getSpecification().clone();
            }
            return this.estimations[0].getSpecification().clone();
        }
        return this.select(data, d, bd);
    }

    static class Builder {
        private int modelsCount = 5;
        private boolean wn = false;
        private boolean balanced = false;
        private boolean mixed = true;
        private double eps = 1.0E-5;
        private int maxP = 2;
        private int maxBp = 1;
        private int maxQ = 2;
        private int maxBq = 1;

        private Builder() {
        }

        Builder balanced(boolean balanced) {
            this.balanced = balanced;
            return this;
        }

        Builder mixed(boolean mixed) {
            this.mixed = mixed;
            return this;
        }

        Builder estimationPrecision(double eps) {
            this.eps = eps;
            return this;
        }

        Builder modelsCount(int n) {
            this.modelsCount = n;
            return this;
        }

        Builder maxP(int p) {
            this.maxP = p;
            return this;
        }

        Builder maxBp(int bp) {
            this.maxBp = bp;
            return this;
        }

        Builder maxQ(int q) {
            this.maxQ = q;
            return this;
        }

        Builder maxBq(int bq) {
            this.maxBq = bq;
            return this;
        }

        Builder acceptWhiteNoise(boolean ok) {
            this.wn = ok;
            return this;
        }

        ArmaModule build() {
            return new ArmaModule(this);
        }
    }

    public static final class CInfo
    implements IArmaModule.Info {
        private final RegArmaBic[] models;
        private final SarmaOrders selection;

        public SarmaOrders bestModel() {
            return this.selection;
        }

        public SarmaOrders[] models() {
            SarmaOrders[] m = new SarmaOrders[this.models.length];
            for (int i = 0; i < m.length; ++i) {
                if (this.models[i] == null) continue;
                m[i] = this.models[i].getSpecification();
            }
            return m;
        }

        public double[] bic() {
            double[] d = new double[this.models.length];
            for (int i = 0; i < d.length; ++i) {
                d[i] = this.models[i] != null ? this.models[i].getBIC() : Double.NaN;
            }
            return d;
        }

        @Generated
        public CInfo(RegArmaBic[] models, SarmaOrders selection) {
            this.models = models;
            this.selection = selection;
        }

        @Generated
        public RegArmaBic[] getModels() {
            return this.models;
        }

        @Generated
        public SarmaOrders getSelection() {
            return this.selection;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CInfo)) {
                return false;
            }
            CInfo other = (CInfo)o;
            if (!Arrays.deepEquals(this.getModels(), other.getModels())) {
                return false;
            }
            SarmaOrders this$selection = this.getSelection();
            SarmaOrders other$selection = other.getSelection();
            return !(this$selection == null ? other$selection != null : !this$selection.equals(other$selection));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getModels());
            SarmaOrders $selection = this.getSelection();
            result = result * 59 + ($selection == null ? 43 : $selection.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "ArmaModule.CInfo(models=" + Arrays.deepToString(this.getModels()) + ", selection=" + String.valueOf(this.getSelection()) + ")";
        }
    }

    public static class RegArmaBic
    implements Comparable<RegArmaBic> {
        private final double bic;
        private final SarimaModel arima;

        RegArmaBic(DoubleSeq data, SarmaOrders spec, double eps) {
            IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)eps);
            RegArimaModel model = RegArimaModel.builder().y(data).arima((IArimaModel)SarimaModel.builder((SarmaOrders)spec).setDefault().build()).build();
            RegArimaEstimation est = processor.process(model, null);
            if (est != null) {
                this.bic = est.statistics().getBIC2();
                this.arima = (SarimaModel)est.getModel().arima();
            } else {
                this.bic = 99999.0;
                this.arima = null;
            }
        }

        @Override
        public int compareTo(RegArmaBic o) {
            return Double.compare(this.bic, o.bic);
        }

        public double getBIC() {
            return this.bic;
        }

        public SarmaOrders getSpecification() {
            return this.arima.orders().doStationary();
        }

        static void mergeInto(RegArmaBic[] estimations, RegArmaBic[] models) {
            if (estimations == null) {
                return;
            }
            int nmax = estimations.length;
            int gmod = models.length;
            if (nmax > gmod) {
                nmax = gmod;
            }
            int icur = 0;
            block0: for (int i = 0; i < nmax && icur < gmod; ++i) {
                double bic = estimations[i].getBIC();
                for (int j = icur; j < gmod; ++j) {
                    if (models[j] == null) {
                        models[j] = estimations[i];
                        icur = j + 1;
                        continue block0;
                    }
                    if (models[j].getSpecification().equals((Object)estimations[i].getSpecification())) {
                        icur = j + 1;
                        continue block0;
                    }
                    if (!(models[j].getBIC() > bic)) continue;
                    for (int k = gmod - 1; k > j; --k) {
                        models[k] = models[k - 1];
                    }
                    models[j] = estimations[i];
                    icur = j + 1;
                    continue block0;
                }
            }
        }

        public static RegArmaBic[] sort(DoubleSeq data, SarmaOrders[] specs, double eps) {
            ArrayList<RegArmaBic> all = new ArrayList<RegArmaBic>();
            for (int i = 0; i < specs.length; ++i) {
                RegArmaBic cur = new RegArmaBic(data, specs[i], eps);
                if (cur.getBIC() == 99999.0) continue;
                all.add(cur);
            }
            Collections.sort(all);
            return all.toArray(new RegArmaBic[all.size()]);
        }
    }
}

