% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGenos.R
\name{plotGenos}
\alias{plotGenos}
\title{Plot graphical genotypes.}
\usage{
plotGenos(genos = "genotypes", markerToPlot = "all",
  individualsToPlot = "all", chromToPlot = "all",
  alleleColors = c("#56B4E9", "#E69F00", "#009E73", "#000000"),
  textSize = 12, showMarkerNames = FALSE, showIndividualNames = FALSE)
}
\arguments{
\item{genos}{The output of readABHgenotypes}

\item{markerToPlot}{A character vector of marker names which appear in the
plot. Defaults to all.}

\item{individualsToPlot}{A character vector of individual names which appear
in the plot. Defaults to all.}

\item{chromToPlot}{A character vector of chromosome names which appear in the
plot. Defaults to all.}

\item{alleleColors}{A character vector of length 4 giving the color names or
values to use for the A,B,H and n.d genotypes. Defaults to orange, blue,
green and black.}

\item{textSize}{The size of all text elements in the plot. Useful for making a
nice plot. Defaults to 12.}

\item{showMarkerNames}{Show the marker names along the x axis. This and
showIndividualNames are useful when you display only a few markers and
want them labeled. Defaults to FALSE.}

\item{showIndividualNames}{Show individual names along the y axis.}
}
\value{
Graphical genotypes.
}
\description{
Plot graphical genotypes.
}
\examples{
\dontrun{plotGenos(genotypes)}
markerNames <- c("marker1", "marker2", "marker3")
individualNames <- c("F2_100", "F2_101", "F2_102", "F2_103")
someColors <- c("black", "red", "gold", "white")
\dontrun{plotgenos(genotypes, markerNames, individualNames, 1:3, someColors)}

\dontrun{p <- plotGenos(genotypes)}
}

