% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopriEndpt.R
\name{OneArm.CondPower}
\alias{OneArm.CondPower}
\title{Conditional power for one-arm, two-stage design with two primary endpoints}
\usage{
OneArm.CondPower(mu1, mu2, n1, n2, rho, tau, alpha2, alternative)
}
\arguments{
\item{mu1}{mean value for the first stage (endpoint 1).}

\item{mu2}{mean value for the second stage (endpoint 2).}

\item{n1}{sample size for the first stage.}

\item{n2}{sample size for the second stage.}

\item{rho}{correlation coefficient between two coprimary endpoints.}

\item{tau}{information time for the interim analysis.}

\item{alpha2}{significant level for the second stage.}

\item{alternative}{indicates the alternative hypothesis and must be one of \code{"two.sided"} or \code{"two.sided"}.}
}
\value{
The evaluated power with attributes and computational error.
}
\description{
Given the group sequential design information, returns the conditional power.
}
\examples{
# Example in Chang (2014) page  277
OneArm.CondPower(mu1=0.1333, mu2=0.1605, n1=130, n2=130, rho=0.35,
 tau=0.5, alpha2=0.024, alternative = "one.sided")
OneArm.CondPower(mu1=0.1333, mu2=0.1605, n1=130, n2=414, rho=0.35,
 tau=0.5, alpha2=0.024, alternative = "one.sided")
}
\author{
Yalin Zhu
}
\references{
Chang, M. (2014). Adaptive design theory and implementation using SAS and R.
\emph{CRC Press}.
}

