% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFfunction.R
\name{AFfunction}
\alias{AFfunction}
\title{Plot the attributable fraction as a function of heritability, disease prevalence, size of target group and intervention effect.}
\usage{
AFfunction(Prevalence, Heritability, Target, Intervention, xaxis, compare,
  Intervention_type = "location", plot = TRUE, legend = TRUE,
  cex = 1.4, ...)
}
\arguments{
\item{Prevalence}{an estimate of the disease prevalence}

\item{Heritability}{an estimate of the disease heritability}

\item{Target}{proportion of those at highest genetic risk being targeted by the intervention}

\item{Intervention}{effect of intervention}

\item{xaxis}{option to specify which of the arguments \code{Prevalence, Heritability, Target} or \code{Intervention} should be used as the xaxis of the plot. The argument \code{xaxis} is a string with values \code{"Prevalence", "Heritability", "Target"} or \code{"Intervention"}.}

\item{compare}{option to specify which of the arguments \code{Prevalence, Heritability, Target} or \code{Intervention} should be used for comparisons. The argument \code{compare} can be specified as a numeric vector with a range of values or as a single value, see examples.}

\item{Intervention_type}{an option to specify how the intervention is expected to affect the genetic liability distribution. The default option \code{"location"} assumes that the intervention shifts the genetic liability distribution to lower levels, among those targeted by the intervention. The option \code{"scale"} assumes that the intervention reduce the variance of the genetic liability distribution, among those targeted by the intervention.}

\item{plot}{option to return a plot. Default is set to \code{TRUE}.}

\item{legend}{option to return a legend in the plot. Default is set to \code{TRUE}.}

\item{cex}{specifies the text size in the plot. Default is set to size \code{1.4}.}

\item{...}{further arguments to be passed to the ggplot function. See \code{\link[ggplot2]{ggplot}}.}
}
\value{
\item{AF}{the AF as a function of heritability, disease prevalence, size of target group and intervention effect.}

\item{plot}{Plot of the AF as a function of either heritability, disease prevalence, size of target group and intervention effect. The legend shows a comparison variable.}
}
\description{
\code{AFfunction} is a function which illustrates the AF as a function of heritability, disease prevalence, size of target group and intervention effect.
}
\details{
The AFfunction() is a function that produce a plot of the AF as a function of \code{Prevalence, Heritability, Target} or \code{Intervention}. A user interface of the function is provided in \code{\link[AFheritability]{runShinyApp}}.
}
\examples{
# Example
heritability <- seq(0,1, by=0.1)
target_sizes <- sort(c(0.30, 0.25, 0.20, 0.15, 0.05, 0.01))

AF_h <- AFfunction(Prevalence=0.5, Heritability = heritability,
                   Target = target_sizes, Intervention = 1,
                   compare="Target", xaxis = "Heritability",
                   ylim = c(0,0.3), cex = 1.6)

AF_h
}
\references{
Dahlqwist E et al. (2019) <doi:10.1007/s00439-019-02006-8>.
}
