% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Repeated.R
\name{repfit}
\alias{repfit}
\alias{repfit.Repeated}
\title{Fit the data to the \link{AIPW} object repeatedly}
\arguments{
\item{num_reps}{Integer. Number of repetition of cross-fitting procedures (\code{fit()} or \code{stratified_fit()} see blow).}

\item{stratified}{Boolean. \code{stratified = TRUE} will use \code{stratified_fit()} in the \link{AIPW} object to cross-fitting.}
}
\value{
A \link{Repeated} object with \code{repeated_estimates} (\code{estimates} from num_reps times repetition)
}
\description{
Fitting the data into the \link{AIPW} object with cross-fitting repeatedly to obtain multiple estimates from repetitions to avoid randomness due to splits in cross-fitting
}
\section{R6 Usage}{

\code{$repfit(num_reps = 20, stratified = FALSE)}
}

\references{
Chernozhukov V, Chetverikov V, Demirer M, et al (2018). Double/debiased machine learning for treatment and structural parameters. \emph{The Econometrics Journal}.
}
\seealso{
\link{Repeated} and \link{AIPW}
}
