% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fine_tune_data.R
\name{create_fine_tune_data}
\alias{create_fine_tune_data}
\title{Function to generate dataset to be used for fine-tuning models}
\usage{
create_fine_tune_data(data, prompt, studyid, title, abstract)
}
\arguments{
\item{data}{Dataset containing the titles and abstracts.}

\item{prompt}{Prompt(s) to be added before the title and abstract.}

\item{studyid}{Unique Study ID. If missing, this is generated
automatically.}

\item{title}{Name of the variable containing the title information.}

\item{abstract}{Name of variable containing the abstract information.}
}
\value{
A dataset of class \code{'fine_tune_data'}.
}
\description{
This function creates the initial data that can be used to fine tune models from OpenAI.
}
\note{
The dataset contains at least the following variables:
\tabular{lll}{
\bold{studyid} \tab \code{integer/character/factor} \tab indicating the study ID of the reference. \cr
\bold{title} \tab \code{character} \tab indicating the title of the reference. \cr
\bold{abstract} \tab \code{character} \tab indicating the abstract of the reference. \cr
\bold{question} \tab \code{character} \tab indicating the final question sent to OpenAI's GPT API models for training. \cr
}
}
\examples{
# Extract 5 irrelevant and relevant records, respectively.
dat <- filges2015_dat[c(1:5, 261:265),]

prompt <- "Is this study about functional family therapy?"

dat <-
  create_fine_tune_data(
    data = dat,
    prompt = prompt,
    studyid = studyid,
    title = title,
    abstract = abstract
   )

dat

}
\seealso{
\code{\link[=save_fine_tune_data]{save_fine_tune_data()}}
}
