% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suit.R
\name{suit}
\alias{suit}
\title{Suitability Scores/Class of the Land Units}
\usage{
suit(
  crop,
  terrain = NULL,
  water = NULL,
  temp = NULL,
  mf = "triangular",
  sow_month = NULL,
  minimum = NULL,
  maximum = "average",
  interval = NULL,
  sigma = NULL
)
}
\arguments{
\item{crop}{a string for the name of the crop;}

\item{terrain}{a data frame for the terrain characteristics of the input land units;}

\item{water}{a data frame for the water characteristics of the input land units;}

\item{temp}{a data frame for the temperature characteristics of the input land units;}

\item{mf}{membership function with default assigned to \code{"triangular"} 
fuzzy model. Other fuzzy models included are \code{"trapezoidal"} and
\code{"gaussian"}.}

\item{sow_month}{sowing month of the crop. Takes integers from 1 to 12 
(inclusive), representing the twelve months of the year. 
So if sets to 1, the function assumes sowing month to be 
January.}

\item{minimum}{factor's minimum value. If \code{NULL} (default), \code{minimum} is
set to 0. But if numeric of length one, say 0.5, then minimum 
is set to 0.5, for all factors. To set multiple minimums for multiple factors,
simply concatenate these into a numeric vector, the length of this vector should be equal
to the number of factors in input land units parameters. However, it can also be set to
\code{"average"}, please refer to the online documentation for more, link in the "See Also" section below.}

\item{maximum}{maximum value for factors. To set multiple maximums for multiple factors,
simply concatenate these into a numeric vector, the length of this vector should be equal
to the number of factors in input land units parameters. However, it can also be set to
\code{"average"}, please refer to the online documentation for more, link in the "See Also" section below.}

\item{interval}{domains for every suitability class (S1, S2, S3). If fixed (\code{NULL}), the
interval would be 0 to 25\% for N (Not Suitable), 25\% to 50\% for S3 (Marginally Suitable),
50\% to 75\% for S2 (Moderately Suitable), and 75\% to 100\% for (Highly Suitable). If \code{"unbias"},
the package will take into account the shape of the membership function, and provide the 
appropriate suitability class intervals. However, it can also be customized by specifying the 
limits of the suitability classes. Please refer to the online documentation for more, link in the "See Also" section below.}

\item{sigma}{If \code{mf = "gaussian"}, then sigma represents the constant sigma in the
Gaussian formula.}
}
\value{
A list of outputs of target characteristics, with the following components: 
\itemize{
\item \code{"terrain"} - a list of outputs for terrain characteristics
\item \code{"soil"} - a list of outputs for soil characteristics
\item \code{"water"} - a list of outputs for water characteristics
\item \code{"temp"} - a list of outputs for temperature characteristics
}
These components are only available when specified as the target characteristics in either 
of the arguments above, that is, if \code{terrain} argument is specified above, then the \code{"terrain"}
and \code{"soil"} components will be available in the output list. This is also true if \code{water} and \code{temp}
are specified in the arguments above. 

Each of the components returned above contains a list of outputs as well
with the following components: 
\itemize{
\item \code{"Factors Evaluated"} - a character of factors that matched between the input land units factor and the targetted crop requirement factor
\item \code{"Suitability Score"} - a data frame of suitability scores for each of the matched factors
\item \code{"Suitability Class"} - a data frame of suitability classes for each of the matched factors
\item \code{"Factors' Minimum Values"} - a numeric of minimum values used in the membership function for computing the suitability scores
\item \code{"Factors' Minimum Values"} - a numeric of maximum values used in the membership function for computing the suitability scores
\item \code{"Factors' Weights"} - a numeric of weights of the factors specified in the input crop requirements
\item \code{"Crop Evaluated"} - a character of the name of the targetted crop requirement dataset
}
}
\description{
This function calculates the suitability scores and class of the land units.
}
\examples{
library(ALUES)

rice_suit <- suit("ricebr", water=MarinduqueWater, temp=MarinduqueTemp, sow_month = 1)
lapply(rice_suit[["water"]], function(x) head(x)) # access results for water suitability
lapply(rice_suit[["temp"]], function(x) head(x)) # access results for temperature suitability
rice_suit <- suit("ricebr", terrain=MarinduqueLT)
lapply(rice_suit[["terrain"]], function(x) head(x))
lapply(rice_suit[["soil"]], function(x) head(x))
}
\seealso{
\code{https://alstat.github.io/ALUES/}
}
