% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOFA-random.R
\name{GRF}
\alias{GRF}
\title{Generating random frequencies}
\usage{
GRF( design, n, prob = NULL, f = "Freq" )
}
\arguments{
\item{design}{A list with the factors and the categories within each.}

\item{n}{How many simulated participants are to be classified.}

\item{prob}{(optional) the probability of falling in each cell of the design.}

\item{f}{(optional) the column names that will contain the frequencies.}
}
\value{
a data frame containing frequencies per cells of the design.
}
\description{
The function \code{GRF()}
generates random frequencies based on a design, i.e.,
a list giving the factors and the categories with each factor.
The data are given in the \code{compiled} format.
}
\details{
The name of the function \code{GRF()} is derived from \code{grd()},
a general-purpose tool to generate random data \insertCite{ch19}{ANOFA} now bundled
in the \code{superb} package \insertCite{cgh21}{ANOFA}.
}
\examples{

# The first example disperse 20 particants in one factor having
# two categories (low and high):
design <- list( A=c("low","high"))
GRF( design, 20 )

# This example has two factors, with factor A having levels a, b, c:
design <- list( A=letters[1:3], B = c("low","high"))
GRF( design, 40 )

# This last one has three factors, for a total of 3 x 2 x 2 = 12 cells
design <- list( A=letters[1:3], B = c("low","high"), C = c("cat","dog"))
GRF( design, 100 )

# To specify unequal probabilities, use
design <- list( A=letters[1:3], B = c("low","high"))
GRF( design, 100, c(.05, .05, .35, .35, .10, .10 ) )

# The name of the column containing the frequencies can be changes
GRF( design, 100, f="patate")

}
\references{
\insertAllCited{}
}
