% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOPA-contrastProportions.R
\name{contrastProportions}
\alias{contrastProportions}
\title{contrastProportions: analysis of contrasts between proportions using Anscombe transform.}
\usage{
contrastProportions(w = NULL, contrasts = NULL)
}
\arguments{
\item{w}{An ANOPA object obtained from \code{anopa()} or \code{emProportions()};}

\item{contrasts}{A list that gives the weights for the contrasts to analyze.
The contrasts within the list can be given names to distinguish them.
The contrast weights must sum to zero and their cross-products must equal 0
as well.}
}
\value{
A table of significance of the different contrasts.
}
\description{
The function \code{contrastProportions()} performs contrasts analyses
on proportion data after an omnibus analysis has been obtained with 'anopa()'
according to the ANOPA framework. See \insertCite{lc23;textual}{ANOPA} for more.
}
\details{
\code{contrastProportions()} computes the \emph{F} for the contrasts,
testing the hypothesis that it equals zero.
The contrasts are each 1 degree of freedom, and the sum of the contrasts'
degrees of freedom totalize the degrees of freedom of the effect being decomposed.
}
\examples{
# Basic example using a one between-subject factor design with the data in compiled format. 
# Ficticious data present success or failure of observation classified according
# to the state of residency (three levels); 175 participants have been observed in total.

# The cells are unequal:
minimalBSExample

# First, perform the omnibus analysis :
w <- anopa( {s;n} ~ state, minimalBSExample) 
summary(w)

# Compare the first two states jointly to the third, and
# compare the first to the second state:
cw <- contrastProportions( w, list(
         contrast1 = c(1,  1, -2)/2,
         contrast2 = c(1, -1,  0) )
      )
summary(cw)




}
\references{
\insertAllCited{}
}
