% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_emo_support.R
\name{calc_emo_support}
\alias{calc_emo_support}
\title{Calculate Emotional Support Score}
\usage{
calc_emo_support(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `emo_support`, where `emo_support`
is the calculated emotional support score for each participant. Participants who did not answer
all four questions will have an NA score.
}
\description{
This function computes an emotional support score on a 0-100 scale based on
survey responses. The score is the mean of four specific item scores, with higher
scores indicating more emotional support.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 4),
  question_concept_id = rep(c(40192399, 40192439, 40192446, 40192528), times = 3),
  answer_concept_id = sample(c(40192454, 40192518, 40192486, 40192382, 40192521),
                             12, replace = TRUE)
)

# Compute emotional support scores
emo_support_scores <- calc_emo_support(survey_df)
head(emo_support_scores)

}
