% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_loneliness.R
\name{calc_loneliness}
\alias{calc_loneliness}
\title{Calculate Loneliness Score}
\usage{
calc_loneliness(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `loneliness`, where `loneliness`
is the calculated loneliness score for each participant. The score is the sum of the individual item scores,
with higher values indicating a higher degree of loneliness. Participants who did not answer all 8 questions will have NA values.
}
\description{
This function computes a loneliness score based on responses to 8 specific items.
The score ranges from 8 to 32, with higher scores indicating a greater degree of loneliness.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 8),
  question_concept_id = rep(c(40192390, 40192397, 40192398, 40192494,
                              40192501, 40192504, 40192507, 40192516), times = 3),
  answer_concept_id = sample(c(40192465, 40192481, 40192429, 40192482),
                             24, replace = TRUE)
)

# Compute loneliness scores
loneliness_scores <- calc_loneliness(survey_df)
head(loneliness_scores)

}
