% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_religious_attendance.R
\name{calc_religious_attendance}
\alias{calc_religious_attendance}
\title{Calculate Religious Attendance Frequency}
\usage{
calc_religious_attendance(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer`.}
}
\value{
A data frame with two columns: `person_id` and `religious_attendance`, where `religious_attendance`
indicates how often the participant attends religious meetings or services. Participants without data or who skipped the question will have NA values.
}
\description{
This function creates an ordinal categorical variable indicating the frequency of attending religious meetings or services, based on participant responses.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 2, 3, 4, 5),
  question_concept_id = rep(40192470, 5),
  answer = c("Never", "Once a week", "More than once a week", "Never", "Skip")
)

# Compute religious attendance frequency
religious_attendance_scores <- calc_religious_attendance(survey_df)
head(religious_attendance_scores)

}
