% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.aq.models.R
\name{other.aq.models}
\alias{other.aq.models}
\alias{fitNearSiteModel}
\title{Other Air Quality Models}
\usage{
fitNearSiteModel(data, pollutant = "no2", y, x = "rest", elements = NULL, ...)
}
\arguments{
\item{data}{\code{data.frame} (or similar) containing data-series
to be modelled; this is expected to contain 'date', 'site'
and pollutant of interest data-series.}

\item{pollutant}{The name of the \code{pollutant} (in
\code{data}) to model, by default 'NO2'.}

\item{y}{The name of the monitor site to be modelled,
assumed to be one several names in the \code{site} column of
\code{data}.}

\item{x}{The other sites to use when building the model, the
default 'rest' uses all supplied sites except 'y'.}

\item{elements}{The number of inputs to use in the
site models, can be any number up to length of x or
combination thereof; by default this is set as
\code{length(x):1}}

\item{...}{extra arguments.}
}
\value{
\code{data} with model output added as additional
column.
}
\description{
Other packaged Air Quality Models.
}
\details{
\code{fitNearSiteModel} builds an air quality
model for one location using air quality data from nearby
sites.
}
