% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMALSTM.R
\name{ARMA.LSTM}
\alias{ARMA.LSTM}
\title{Hybrid ARMA-LSTM Model for Time Series Forecasting}
\usage{
ARMA.LSTM(X, p, q, arfima = FALSE, dist.model= "ged", out.sample, LSTM.units,
ACTIVATION.function = "tanh", DROPOUT = 0.2, Optimizer ="adam", Epochs = 100,
LSTM.loss = "mse", LSTM.metrics = "mae")
}
\arguments{
\item{X}{A univariate time series data}

\item{p}{Order of AR}

\item{q}{Order of MA}

\item{arfima}{Whether to include arfima (0<d<0.5)}

\item{dist.model}{The distribution density to use for the innovation. The default distribution for the mean model used is "ged". Other choices can be obtained from the rugarch package.}

\item{out.sample}{A positive integer indicating the number of periods before the last to keep for out of sample forecasting. To be considered as test data.}

\item{LSTM.units}{Number of units in the LSTM layer}

\item{ACTIVATION.function}{Activation function}

\item{DROPOUT}{Dropout rate}

\item{Optimizer}{Optimizer used for optimization of the LSTM model}

\item{Epochs}{Number of epochs of the LSTM model}

\item{LSTM.loss}{Loss function}

\item{LSTM.metrics}{Metrics}
}
\value{
\itemize{
  \item ARMA.fit: Parameters of the fitted ARMA model
  \item ARMA.fitted: Fitted values of the ARMA model
  \item ARMA.residual: Residual values of the ARMA model
  \item ARMA.forecast: Forecast values obtained from the ARMA model for the test data
  \item ARMA.residual.nonlinearity.test: BDS test results for the ARMA residuals
  \item LSTM.lag: Lag used for the LSTM model
  \item FINAL.fitted: Fitted values of the hybrid ARMA-LSTM model
  \item FINAL.residual: Residual values of the hybrid ARMA-LSTM model
  \item FINAL.forecast: Forecast values obtained from the hybrid ARMA-LSTM model for the test data
  \item ACCURACY.MATRIX: RMSE, MAE and MAPE of the train and test data
}
}
\description{
The linear ARMA model is fitted to the time series. The significant number of PACF values of ARMA residuals are considered as the lag. The LSTM model is fitted to the ARMA residuals setting the lag value as the time step. User needs to install keras, tensorflow and reticulate packages as the prerequisite to implement this package.
}
\examples{
\donttest{
y<-c(5,9,1,6,4,9,7,3,5,6,1,8,6,7,3,8,6,4,7,5)
my.hybrid<-ARMA.LSTM(y, p=1, q=0, arfima=FALSE, dist.model = "ged",
out.sample=10, LSTM.units=50, ACTIVATION.function = "tanh",
DROPOUT = 0.2, Optimizer ="adam", Epochs = 10, LSTM.loss = "mse", LSTM.metrics = "mae")
}
}
\references{
\itemize{
\item Box, G. E., Jenkins, G. M., Reinsel, G. C., & Ljung, G. M. (2015). Time series analysis: forecasting and control. John Wiley & Sons.
\item Granger, C. W., & Joyeux, R. (1980). An introduction to long-memory time series models and fractional differencing. Journal of time series analysis, 1(1), 15-29.
\item Hochreiter, S., & Schmidhuber, J. (1997). Long short-term memory. Neural computation, 9(8), 1735-1780.
\item Rakshit, D., Paul, R. K., & Panwar, S. (2021). Asymmetric price volatility of onion in India. Indian Journal of Agricultural Economics, 76(2), 245-260.
\item Rakshit, D., Paul, R. K., Yeasin, M., Emam, W., Tashkandy, Y., & Chesneau, C. (2023). Modeling Asymmetric Volatility: A News Impact Curve Approach. Mathematics, 11(13), 2793.
\item Rakshit, D., Roy, A., Atta, K., Adhikary, S., & Vishwanath. (2022). Modeling Temporal Variation of Particulate Matter Concentration at Three Different Locations of Delhi. International Journal of Environment and Climate Change, 12(11), 1831-1839.
}
}
