% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat122}
\alias{simDat122}
\title{Simulate data for Chapter 12.2: Overdispersed counts}
\usage{
simDat122(nSites = 50, alpha = log(2), beta = log(5) - log(2), sd = 0.5)
}
\arguments{
\item{nSites}{Number of sites}

\item{alpha}{Intercept}

\item{beta}{Slope for land use}

\item{sd}{Standard deviation for overdispersion}
}
\value{
A list of simulated data and parameters.
  \item{nSites}{Number of sites}
  \item{alpha}{Intercept}
  \item{beta}{Slope for land use}
  \item{sd}{Standard deviation for overdispersion}
  \item{C_OD}{Simulated hare counts with overdispersion}
  \item{C_Poisson}{Simulated hare counts without overdispersion}
}
\description{
Generate counts of hares in two landuse types
when there may be overdispersion relative to a Poisson
}
\examples{
str(dat <- simDat122())      # Implicit default arguments

# Much greater OD to emphasize patterns (also larger sample size)
str(dat <- simDat122(nSites = 100, sd = 1))

# Revert to "Poisson model-of-the-mean" (i.e., without an effect of landuse type)
str(dat <- simDat122(nSites = 100, beta = 0, sd = 1))

}
\author{
Marc Kéry
}
