% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASSISTDesigns.R
\name{ASSISTDesignC}
\alias{ASSISTDesignC}
\title{A fixed sample RCT design to compare against the adaptive clinical
trial design of Lai, Lavori and Liao.}
\description{
\code{ASSISTDesignC} objects are used to design a trial
with certain characteristics provided in the object instantiation
method. This design differs from \code{ASSISTDesign} in only how it
computes the critical boundaries, how it performs the interim
look, and what quantities are computed in a trial run.
}
\examples{
data(LLL.SETTINGS)
prevalence <- LLL.SETTINGS$prevalences$table1
scenario <- LLL.SETTINGS$scenarios$S0
designParameters <- list(prevalence = prevalence,
                       mean = scenario$mean,
                       sd = scenario$sd)
## A realistic design uses 5000 simulations or more!
designC <- ASSISTDesignC$new(trialParameters = LLL.SETTINGS$trialParameters,
                            designParameters = designParameters)
print(designC)
result <- designC$explore(numberOfSimulations = 100, showProgress = interactive())
analysis <- designC$analyze(result)
designC$summary(analysis)
## For full examples, try:
## browseURL(system.file("full_doc/ASSISTant.html", package="ASSISTant"))

}
\seealso{
\code{ASSISTDesignB} which is a superclass of this object
}
\section{Super classes}{
\code{\link[ASSISTant:ASSISTDesign]{ASSISTant::ASSISTDesign}} -> \code{\link[ASSISTant:ASSISTDesignB]{ASSISTant::ASSISTDesignB}} -> \code{ASSISTDesignC}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ASSISTDesignC-computeCriticalValues}{\code{ASSISTDesignC$computeCriticalValues()}}
\item \href{#method-ASSISTDesignC-explore}{\code{ASSISTDesignC$explore()}}
\item \href{#method-ASSISTDesignC-analyze}{\code{ASSISTDesignC$analyze()}}
\item \href{#method-ASSISTDesignC-summary}{\code{ASSISTDesignC$summary()}}
\item \href{#method-ASSISTDesignC-clone}{\code{ASSISTDesignC$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getBoundaries"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getBoundaries'><code>ASSISTant::ASSISTDesign$getBoundaries()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getDesignParameters"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getDesignParameters'><code>ASSISTant::ASSISTDesign$getDesignParameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getTrialParameters"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getTrialParameters'><code>ASSISTant::ASSISTDesign$getTrialParameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="initialize"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-initialize'><code>ASSISTant::ASSISTDesign$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="performInterimLook"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-performInterimLook'><code>ASSISTant::ASSISTDesign$performInterimLook()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="print"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-print'><code>ASSISTant::ASSISTDesign$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="setBoundaries"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-setBoundaries'><code>ASSISTant::ASSISTDesign$setBoundaries()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignC-computeCriticalValues"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignC-computeCriticalValues}{}}}
\subsection{Method \code{computeCriticalValues()}}{
Compute the critical boundary values \eqn{\tilde{b}}, \eqn{b} and \eqn{c} for futility, efficacy and final efficacy decisions. This is time consuming so cache where possible.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignC$computeCriticalValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a named list containing the critical value \code{cAlpha}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignC-explore"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignC-explore}{}}}
\subsection{Method \code{explore()}}{
Explore the design using the specified number of simulations and random number seed and other parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignC$explore(
  numberOfSimulations = 5000,
  rngSeed = 12345,
  trueParameters = self$getDesignParameters(),
  showProgress = TRUE,
  saveRawData = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numberOfSimulations}}{default number of simulations is 5000}

\item{\code{rngSeed}}{default seed is 12345}

\item{\code{trueParameters}}{the state of nature, by default the value of \code{self$getDesignParameters()} as would be the case for a Type I error calculation. If changed, would yield power.}

\item{\code{showProgress}}{a boolean flag to show progress, default \code{TRUE}}

\item{\code{saveRawData}}{a flag (default \code{FALSE}) to indicate if raw data has to be saved}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignC-analyze"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignC-analyze}{}}}
\subsection{Method \code{analyze()}}{
Analyze the design given the \code{trialExploration} data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignC$analyze(trialExploration)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trialExploration}}{the results from a call to \code{explore()} to simulate the design}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a named list of rejections
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignC-summary"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignC-summary}{}}}
\subsection{Method \code{summary()}}{
Print the operating characteristics of the design using the analysis data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignC$summary(analysis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{analysis}}{the analysis result from the \code{analyze()} call}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no value, just print
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignC-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignC-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
