% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_function.R
\name{corgraph}
\alias{corgraph}
\title{Graph: Correlogram}
\usage{
corgraph(
  data,
  axissize = 12,
  legendsize = 12,
  legendposition = c(0.9, 0.2),
  legendtitle = "Correlation",
  method = "pearson",
  pallete = "RdBu",
  color.marginal = "gray50",
  size.tile.lty = 1,
  size.label.cor = 1,
  fill.label.cor = "lightyellow",
  font.family = "sans"
)
}
\arguments{
\item{data}{data.frame with responses}

\item{axissize}{Axes font size (\emph{default} is 12)}

\item{legendsize}{Legend font size (\emph{default} is 12)}

\item{legendposition}{Legend position (\emph{default} is c(0.9,0.2))}

\item{legendtitle}{Legend title (\emph{default} is "Correlation")}

\item{method}{Method correlation (\emph{default} is Pearson)}

\item{pallete}{If a string, will use that named palette. See scale_fill_distiller in the ggplot2.}

\item{color.marginal}{Box border color}

\item{size.tile.lty}{Box margin line thickness}

\item{size.label.cor}{Label font size}

\item{fill.label.cor}{Label fill color}

\item{font.family}{Font family (\emph{default} is sans)}
}
\value{
The function returns a correlation matrix
}
\description{
Correlation analysis function (Pearson or Spearman)
}
\examples{
data("pomegranate")
corgraph(pomegranate[,-1])
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
