% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_TH_function.R
\name{plot_TH}
\alias{plot_TH}
\title{Graph: Climate chart of temperature and humidity}
\usage{
plot_TH(
  tempo,
  Tmed,
  Tmax,
  Tmin,
  UR,
  xlab = "Time",
  yname1 = expression("Humidity (\%)"),
  yname2 = expression("Temperature ("^o * "C)"),
  legend.H = "Humidity",
  legend.tmed = "Tmed",
  legend.tmin = "Tmin",
  legend.tmax = "Tmax",
  colormax = "red",
  colormin = "blue",
  colormean = "darkgreen",
  fillbar = "gray80",
  limitsy1 = c(0, 100),
  x = "days",
  breaks = "1 months",
  textsize = 12,
  legendsize = 12,
  titlesize = 12,
  linesize = 1,
  date_format = "\%m-\%Y",
  sc = 2.5,
  angle = 0,
  legend.position = "bottom",
  theme = theme_classic()
)
}
\arguments{
\item{tempo}{Vector with times}

\item{Tmed}{Vector with mean temperature}

\item{Tmax}{Vector with maximum temperature}

\item{Tmin}{Vector with minimum temperature}

\item{UR}{Vector with relative humidity or precipitation}

\item{xlab}{x axis name}

\item{yname1}{y axis name}

\item{yname2}{Secondary y-axis name}

\item{legend.H}{Legend column}

\item{legend.tmed}{Legend mean temperature}

\item{legend.tmin}{Legend minimum temperature}

\item{legend.tmax}{Legend maximum temperature}

\item{colormax}{Maximum line color (\emph{default} is "red")}

\item{colormin}{Minimum line color (\emph{default} is "blue")}

\item{colormean}{Midline color (\emph{default} is "darkgreen")}

\item{fillbar}{Column fill color (\emph{default} is "gray80")}

\item{limitsy1}{Primary y-axis scale (\emph{default} is c(0,100))}

\item{x}{x scale type (days or data, default is "days")}

\item{breaks}{Range for x scale when x = "date" (default is 1 months)}

\item{textsize}{Axis text size}

\item{legendsize}{Legend text size}

\item{titlesize}{Axis title size}

\item{linesize}{Line size}

\item{date_format}{Date format for x="data"}

\item{sc}{Scale for secondary y-axis in relation to primary y-axis (declare the number of times that y2 is less than or greater than y1, the default being 2.5)}

\item{angle}{x-axis scale text rotation}

\item{legend.position}{Legend position}

\item{theme}{ggplot2 theme}
}
\value{
Returns row and column graphs for graphical representation of air temperature and relative humidity. Graph normally used in scientific articles
}
\description{
The plot_TH function allows the user to build a column/line graph with climatic parameters of temperature (maximum, minimum and average) and relative humidity (UR) or precipitation. This chart is widely used in scientific work in agrarian science
}
\examples{
library(AgroR)
data(weather)
with(weather, plot_TH(tempo, Tmed, Tmax, Tmin, UR))
}
\seealso{
\link{sk_graph}, \link{barplot_positive}, \link{corgraph}, \link{plot_TH1}, \link{spider_graph}, \link{line_plot}
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
