% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_conj.R
\name{summarise_conj}
\alias{summarise_conj}
\title{Utils: Summary of Analysis of Variance and Test of Means for Joint analysis}
\usage{
summarise_conj(analysis, design = "DBC", info = "p")
}
\arguments{
\item{analysis}{List with the analysis outputs of the conjdic and conjdbc functions}

\item{design}{Type of experimental project (DIC or DBC)}

\item{info}{Analysis of variance information (can be "p", "f", "QM" or "SQ")}
}
\description{
Summarizes the output of the analysis of variance and the multiple comparisons test for completely randomized (DIC) and randomized block (DBC) designs for Joint analysis with qualitative factor.
}
\note{
The column names in the final output are imported from the ylab argument within each function.

This function is only for declared qualitative factors. In the case of a quantitative factor and the other qualitative in projects with two factors, this function will not work.
}
\examples{
library(AgroR)
data(mirtilo)
set.seed(1); resp1=rnorm(36,10,4)
set.seed(4); resp2=rnorm(36,10,3)
set.seed(8); resp3=rnorm(36,100,40)
type1=with(mirtilo, conjdbc(trat, bloco, exp, resp, ylab = "var1"))
type2=with(mirtilo, conjdbc(trat, bloco, exp, resp1, ylab = "var2"))
type3=with(mirtilo, conjdbc(trat, bloco, exp, resp2, ylab = "var3"))
type4=with(mirtilo, conjdbc(trat, bloco, exp, resp3, ylab = "var4"))
summarise_conj(analysis = list(type1,type2,type3,type4))
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}
}
