% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_pull.R
\name{monitor_pull}
\alias{monitor_pull}
\title{Extract a column of metadata or data}
\usage{
monitor_pull(monitor = NULL, var = NULL)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{var}{A variable name found in the \code{meta} or \code{data}
dataframe of the incoming \emph{mts_monitor} time series object.}
}
\value{
An array of values.
}
\description{
This function acts similarly to \code{\link[dplyr]{pull}} working on
\code{monitor$meta} or \code{monitor$data}. Data are returned as a simple array.
Data are pulled from whichever dataframe contains \code{var}.
}
\examples{
library(AirMonitor)

# Metadata
Camp_Fire \%>\%
  monitor_pull("deploymentType") \%>\%
  table()

# Data for a specific ID
Camp_Fire \%>\%
  monitor_dailyStatistic(mean) \%>\%
  monitor_pull("6bbab08e3786ef66_840060450006") \%>\%
  round(0)

# Associated dates
Camp_Fire \%>\%
  monitor_dailyStatistic(mean) \%>\%
  monitor_pull("datetime")

}
