% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonesrule.R
\name{clonesrule}
\alias{clonesrule}
\title{Allocation rule with cloned agents}
\usage{
clonesrule(cw, eta, rule, group_contribution = TRUE, a = NULL, order = NULL)
}
\arguments{
\item{cw}{A numeric cost vector, with the same length as \code{eta}.}

\item{eta}{A numeric vector representing the size of each group of cloned agents. All its elements must be positive integers.}

\item{rule}{A character string specifying the rule to apply. The rules that can be selected are:
\code{"SFC"}, \code{"SEC"}, \code{"CEC"}, \code{"CP"}, \code{"CEB"}, \code{"SM"}, \code{"CC"}, \code{"SIGMA"} and \code{"PRIOR"}.}

\item{group_contribution}{A logical value.
By default, if \code{group_contribution = TRUE}, the cost allocation vector stores the aggregated contribution for each group of clones.
However, if \code{group_contribution = FALSE}, the cost allocation vector represents the individual contribution of one of the agents in the group of clones.}

\item{a}{A numeric value in the range [0,1], controlling the parameterization of the rule. It can only be defined when \code{rule = "SIGMA"}.
By default, \code{a = 0.5}.}

\item{order}{A numeric vector indicating the priority order of agents when making contributions. It can only be defined when \code{rule = "PRIOR"}.
By default, agents follow their original indexing and contribute accordingly.}
}
\value{
A numeric contribution vector. By default, if \code{group_contribution = TRUE}, each element represents the payment made by each group of cloned agents.
However, if \code{group_contribution = FALSE}, each element reflects the individual payment made by a representative agent from each group.
}
\description{
\code{clonesrule} calculates the contribution vector resulting from the payment allocation among the different agents using one of the versions for clones of the various predefined rules.
}
\details{
Let \eqn{\mathcal{R}} be a rule, \eqn{t\in N}, and \eqn{(\eta,c)\in\mathcal{A}^N_t}. For each \eqn{i\in T=\{1,\dots,t\}},
the sum of the contributions requested by \eqn{\mathcal{R}} from the group of clones \eqn{N^{\eta}_i} is
\eqn{\mathcal{R}(\eta\ast c, N_i^{\eta})=\sum\limits_{j\in N^\eta_i}\mathcal{R}_j(n\ast c)}.

The computation of the cost allocation selected by a rule for a given problem can be substantially simplified where there are cloned agents.
Through this function, a direct method is proposed to obtain either the aggregate contribution or the individual contribution of each group of cloned agents,
based on the associated reduced problem and the number of clones in each group.

The version for clones of the SFC, SEC, CEC and CP rules is equal to their respective weighted version, so the formulation of these rules will be the same
for the weighted version. Only the CEB rule has a weighted version and a clone version that are different.

If a rule \eqn{\mathcal{R}} satisfies equal treatment of equals (cloned agents pay equal amounts), then
\eqn{\mathcal{R}(\eta\ast c,N_i^\eta)=\eta_i\mathcal{R}_s(n\ast c)} for any \eqn{s\in N_i^\eta}. All the rules listed, with the
exception of the PRIOR rule, satisfy equal treatment of equals. Therefore, the contribution demanded by these rules from a group of clones
is divided equally among them.

Finally, we define a \eqn{k}-replica of an airport problem as the problem in which every agent is replaced by \eqn{k} clones of itself.
If \eqn{k} increases, the number of groups of cloned agents does not change, but the number of agents is large. Thus, we say that a rule satisfies
replication invariance if for each \eqn{c\in C^N}, each \eqn{i \in N}, and each \eqn{k\in \mathbb{N}}, we have \eqn{\mathcal{R}(k\ast c,N_i^k)=\mathcal{R}_i(c)};
i.e., if in any \eqn{k}-replica of a problem each group of cloned agents contributes an amount independent of \eqn{k}.
The SFC, SEC, CEC, CP, and PRIOR rules verify this property, while the others do not.
}
\note{
When \code{rule = "CC"}, the execution time of the function may significantly increase if the number of individual agents exceeds 150.
}
\examples{
# Clones SEC rule
cw <- c(1, 3, 7, 10) # Different costs
eta <- c(3, 4, 1, 2)  # Size of each groups of clones
clonesrule(cw, eta, "SEC")

# CEC rule satisfies replication invariance
cw <- c(1, 5, 12) # Different costs
eta <- rep(8, 3) # Size of each groups of clones
all.equal(clonesrule(cw, eta, "CEC"), CECrule(cw))

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Littlechild, S. C. and Thompson, G. F. (1977). Aircraft landing fees: a game theory approach.
\emph{The Bell Journal of Economics}, 8, 186-204.
}
\seealso{
\code{\link{clonesgroups}}, \code{\link{clonesproblem}}, \code{\link{multiclonesrules}}, \code{\link{basicrule}}, \code{\link{weightedrule}}
}
