% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.AncReg}
\alias{summary.AncReg}
\title{Summary of AncReg}
\usage{
\method{summary}{AncReg}(object, alpha = 0.05, verbose = FALSE, corr = TRUE, ...)
}
\arguments{
\item{object}{output from AncReg()}

\item{alpha}{significance level for determin whether a connection is significant}

\item{verbose}{should information be printed?}

\item{corr}{should multiplicity correction be applied?}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A list containing:
If \code{degree = 0}:
\item{p.val}{A numeric matrix of p-values for the instantaneous graph}
\item{graph}{A boolean matrix indicating whether one variable affects another instantaneously}
\item{alpha}{The significance level to avoid cycles}
If \code{degree > 0}:
\item{inst.p.val}{A numeric matrix of p-values for the instantaneous graph}
\item{inst.graph}{A boolean matrix indicating whether one variable affects another instantaneously}
\item{inst.alpha}{The significance level to avoid cycles}
\item{sum.p.val}{A numeric matrix of p-values for the summary graph}
\item{sum.graph}{A boolean matrix indicating whether one variable affects another}
}
\description{
Summarize the results of AncReg. For models with degree = 0 only the instantaneous graph is returned
and for models with degree > 0 the summary graph is returned as well.
}
\examples{
# random DAGS for simulation
set.seed(1234)

p <- 5 #number of nodes
DAG <- pcalg::randomDAG(p, prob = 0.5)

B <- matrix(0, p, p) # represent DAG as matrix
for (i in 2:p){
  for(j in 1:(i-1)){
    # store edge weights
    B[i,j] <- max(0, DAG@edgeData@data[[paste(j,"|",i, sep="")]]$weight)
  }
}
colnames(B) <- rownames(B) <- LETTERS[1:p]

# solution in terms of noise
Bprime <- MASS::ginv(diag(p) - B)

n <- 500
N <- matrix(rexp(n * p), ncol = p)
X <- t(Bprime \%*\% t(N))
colnames(X) <- LETTERS[1:p]

# fit ancestor regression
fit <- AncReg(X)
# collect ancestral p-values and graph
res <- summary(fit, alpha = 1)
res
}
\seealso{
\code{\link{AncReg}}, \code{\link{instant_graph}}, \code{\link{summary_graph}},
\code{\link{instant_p.val}}, \code{\link{summary_p.val}}
}
