% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association_metrics.R
\name{association_metrics}
\alias{association_metrics}
\title{Calculate Association Metrics for Sequences}
\usage{
association_metrics(sequences)
}
\arguments{
\item{sequences}{A character vector of sequences to analyze.}
}
\value{
A data frame with the calculated association metrics for each dyad (pair of elements).
}
\description{
This function calculates various association metrics for elements in a sequence,
such as Pointwise Mutual Information (PMI), normalized PMI, attraction, reliance,
Delta P, z-score, t-score, Chi-squared, Jaccard coefficient, Dice coefficient,
log odds ratio, and geometric mean.
}
\examples{
# Example usage:
sequences <- c("A B C", "A B", "A C", "B C", "A B C D")
result <- association_metrics(sequences)
print(result)
}
