% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_compare_PLM.R
\name{Af_compare_PLM}
\alias{Af_compare_PLM}
\title{Function to compare the distributions of the Protein Language Model probabilities or ranks of the mutations along the edges of B cell lineage trees across repertoires using the Jensen-Shannon divergence.}
\usage{
Af_compare_PLM(PLM_dataframe, values, font.size, output.file)
}
\arguments{
\item{PLM_dataframe}{Dataframe resulting from Af_PLM_dataframe(). This contains the Protein Language Model probabilities and ranks of the mutations along the edges of B cell lineage trees.}

\item{values}{What values to compare
"substitution_rank" will compare the rank of the mutation along the edge of the tree (Highest probability is rank 1).
"substitution_probability" will copmare the probability of the mutation along the edge of the tree.
"original_rank" will compare the rank of the original amino acid at the site of mutation along the edge of the tree (Highest probability is rank 1).
"original_probability" will compare the probability of the original amino acid at the site of mutation along the edge of the tree.
"unmutated_rank" will compare the rank of the unmutated amino acids along the edge of the tree (Highest probability is rank 1).
"unmutated_probability" will compare the probabilities of the unmutated amino acids along the edge of the tree.}

\item{font.size}{Font size for the plot. Default is 16.}

\item{output.file}{string - specifies the path to the output file (PNG of PDF). Defaults to NULL.}
}
\value{
A pheatmap of the Jensen-Shannon distance between repertoires
}
\description{
Function to compare the distributions of the Protein Language Model probabilities or ranks of the mutations along the edges of B cell lineage trees across repertoires using the Jensen-Shannon divergence.
}
\examples{
Af_compare_PLM(PLM_dataframe = AntibodyForests::PLM_dataframe,
            values = "original_probability")
}
