% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Growth_functions.R
\name{Estimate_Growth}
\alias{Estimate_Growth}
\title{Estimate length-at-age parameters and growth curves for Elasmobranchs}
\usage{
Estimate_Growth(
  data,
  models = c("VB", "Log", "Gom"),
  Birth.Len = NULL,
  correlation.matrix = FALSE,
  n.bootstraps = 1000,
  plots = TRUE,
  Max.Age = NULL,
  plot.legend = TRUE
)
}
\arguments{
\item{data}{a data frame which includes 'Age' and 'Length - ideally with these names but the function will except some variation to these}

\item{models}{a vector of models to be fitted. These can include" VB", "Log" and "Gom". A subset can also be used}

\item{Birth.Len}{The length-at-birth to be used for two parameter models. If a value is provided, two parameter models are automatically run}

\item{correlation.matrix}{Should the correlation matrix of parameters be returned? This is the only object returned if TRUE.}

\item{n.bootstraps}{The number of bootstraps performed for model 95 confidence intervals}

\item{plots}{Should plots be printed to the screen. If FALSE then the model estimates and CI's are returned as an additional output}

\item{Max.Age}{Specify the max age for bootstrapped confidence intervals to be produced over. Default is the max age in the data.}

\item{plot.legend}{Do you want a legend for the different models on the plot}
}
\value{
Returns a list of parameter estimates with errors and AIC results. If plots is TRUE then a plot is printed to the screen. If plots is FALSE then the length-at-age estimates are returned as a list element
}
\description{
A multi-model growth estimation approach is applied to length-at-age data. Three models can be applied which include the von Bertalanffy (VB), logistic (Log) and Gompertz (Gom) models. AIC values and weights are calculated. The outputs will return a list of model parameter estimates and will either print a plot to the screen or output the length-at-age estimates as part of the list.Use of this function should cite Smart et al. (2016).
}
\examples{
# load example data set
data("growth_data")
# Run function with three default model candidates. Use 100 bootstraps for
# testing and then increase to at least 1000 for actual model runs.
Estimate_Growth(growth_data, n.bootstraps = 100)
}
\references{
Smart et al. (2016) Multi-model approaches in shark and ray growth studies: strengths, weaknesses and the future. Fish and Fisheries. 17: 955-971\url{https://onlinelibrary.wiley.com/doi/abs/10.1111/faf.12154}
}
