% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ar40Ar39.R
\name{get4039}
\alias{get4039}
\title{Calculate the 40Ar*/39ArK-ratios}
\usage{
get4039(X, irr)
}
\arguments{
\item{X}{an object of class \code{redux} containing some
interference corrected logratio intercept data}

\item{irr}{the irradiation schedule}
}
\value{
an object of class \code{link{redux}} containing the
40Ar*/39ArK-ratios as \code{intercepts} and its covariance matrix
as \code{covmat}
}
\description{
Calculate the 40Ar*/39ArK-ratios of interference corrected logratio
intercept data
}
\examples{
data(Melbourne)
R <- get4039(Melbourne$X,Melbourne$irr)
plotcorr(R)
}
