% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localmeshdiff.R
\name{localmeshdiff}
\alias{localmeshdiff}
\title{localmeshdiff
Calculate and Visualize local differences between two meshes}
\usage{
localmeshdiff(
  mesh1,
  mesh2,
  ploton = 1,
  diffarea = ((area_shape1 - area_shape2)/area_shape2) * 100,
  paltot = rainbow(200),
  from = NULL,
  to = NULL,
  n.int = 200,
  out.rem = TRUE,
  fact = 1.5,
  visual = 1,
  scale01 = TRUE,
  colwire = "pink"
)
}
\arguments{
\item{mesh1}{reference mesh: object of class "mesh3d"}

\item{mesh2}{target mesh: object of class "mesh3d"}

\item{ploton}{numeric: define which mesh will be used to visualize local differences}

\item{diffarea}{formula: define how calculating differences in area. area_shape1 refers to mesh1, area_shape2 refers to mesh2}

\item{paltot}{character vector: specify the colors which are used to create a color palette}

\item{from}{numeric: minimum distance to be colorised}

\item{to}{numeric: maximum distance to be colorised}

\item{n.int}{numeric: determines break points for color palette}

\item{out.rem}{logical: if TRUE outliers will be removed}

\item{fact}{numeric: factor k of the interquartile range}

\item{visual}{numeric: if equals to 1 the mesh is plotted without a wireframe, if set on 2 a wireframe is added}

\item{scale01}{logical: if TRUE the vector of distances is scaled from 0 to 1}

\item{colwire}{character: color of the wireframe}
}
\value{
vect numeric vector containing local differeces in area between the reference and the target mesh
}
\description{
localmeshdiff
Calculate and Visualize local differences between two meshes
}
\examples{
\dontrun{
library(Arothron)
library(rgl)
data("primendoR")
neaset<-primendoR$sets[,,11]
sapset<-primendoR$sets[,,14]
#defining a mesh for the neanderthal right hemisphere
neasur<-list("vb"=t(cbind(neaset,1)),"it"=primendoR$sur$it)
class(neasur)<-"mesh3d"
#defining a mesh for the modern human right hemisphere
sapsur<-list("vb"=t(cbind(sapset,1)),"it"=primendoR$sur$it)
class(neasur)<-"mesh3d"
layout3d(t(c(1,2)),sharedMouse = TRUE)
localmeshdiff(sapsur,neasur,1,scale01 = TRUE,
paltot=c("darkred","red","orange","white","lightblue","blue","darkblue"))
next3d()
localmeshdiff(neasur,sapsur,1,scale01 = TRUE,
paltot=c("darkred","red","orange","white","lightblue","blue","darkblue"))
}
}
\references{
Melchionna, M., Profico, A., Castiglione, S., Sansalone, G., Serio, C., Mondanaro, A., ... & Manzi, G. (2020). 
From smart apes to human brain boxes. A uniquely derived brain shape in late hominins clade. Frontiers in Earth Science, 8, 273.
}
\author{
Antonio Profico, Costantino Buzi, Silvia Castiglione, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
