% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutangle.r
\name{permutangle}
\alias{permutangle}
\title{permutangle}
\usage{
permutangle(
  mat,
  var,
  group1,
  group2,
  scale = FALSE,
  iter = 100,
  cex1 = range01(var[group1] + 1),
  cex2 = range01(var[group2] + 1),
  cex3 = 0.7,
  cex4 = 1.2,
  labels = c("stgr1", "stgr2", "endgr1", "endgr2"),
  pch1 = 19,
  pch2 = 19,
  pch3 = 19,
  col1 = "red",
  col2 = "blue"
)
}
\arguments{
\item{mat}{array: rgb array}

\item{var}{numeric: desidered resize factor}

\item{group1}{logical: if TRUE each color is counted once}

\item{group2}{logical: if TRUE (color) variables are scaled}

\item{scale}{numeric: desidered number of clusters (i.e., number of palettes)}

\item{iter}{numeric: length of the color vector of each palette}

\item{cex1}{numeric: desidered PLS axis}

\item{cex2}{numeric: size of colored squares}

\item{cex3}{numeric: size of color names}

\item{cex4}{numeric: size of color names}

\item{labels}{numeric: size of color names}

\item{pch1}{numeric: size of color names}

\item{pch2}{numeric: size of color names}

\item{pch3}{numeric: size of color names}

\item{col1}{numeric: size of color names}

\item{col2}{numeric: size of color names}
}
\value{
angle list: color palettes arranged in a list

permangles list: color palettes arranged in a list

angle list: color palettes arranged in a list

iterangles list: color palettes arranged in a list

p-value list: color palettes arranged in a list

PCA_angle list: color palettes arranged in a list

PCA_interangles list: color palettes arranged in a list

PCA_p-value list: color palettes arranged in a list
}
\description{
Create palettes from an image
}
\examples{
\dontrun{
require(shapes)
require(Morpho)
data("gorf.dat")
data("gorm.dat")
Array<-bindArr(gorf.dat,gorm.dat,along=3)
CS<-apply(Array,3,cSize)
Sex<-c(rep("F",dim(gorf.dat)[3]),rep("M",dim(gorm.dat)[3]))

#Shape and size space
AllTrajFB<-permutangle(procSym(Array,scale=FALSE,CSinit = FALSE)$PCscores,
var=CS,group1=which(Sex=="F"),group2=which(Sex=="M"),scale=FALSE,iter=50)
hist(AllTrajFB$iterangles,breaks = 100,xlim=c(0,90))
abline(v=AllTrajFB$angle,lwd=2,col="red")
hist(AllTrajFB$PCA_iterangles,breaks = 100,xlim=c(0,90))
abline(v=AllTrajFB$PCA_angle,lwd=2,col="red")

#Shape space
AllTrajFB<-permutangle(procSym(Array)$PCscores,
var=CS,group1=which(Sex=="F"),group2=which(Sex=="M"),scale=FALSE,iter=50)
hist(AllTrajFB$iterangles,breaks = 100,xlim=c(0,90))
abline(v=AllTrajFB$angle,lwd=2,col="red")
hist(AllTrajFB$PCA_iterangles,breaks = 100,xlim=c(0,90))
abline(v=AllTrajFB$PCA_angle,lwd=2,col="red")
}
}
\author{
Antonio Profico
}
