% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anatomicalmassprop.R
\name{massprop_head}
\alias{massprop_head}
\title{Head mass properties}
\usage{
massprop_head(m, r, l, start, end)
}
\arguments{
\item{m}{Mass of head (kg)}

\item{r}{Maximum head radius (m)}

\item{l}{Maximum head length (m)}

\item{start}{a 1x3 vector (x,y,z) representing the 3D point where head starts.
Frame of reference: VRP | Origin: VRP}

\item{end}{a 1x3 vector (x,y,z) representing the 3D point where head ends.
Frame of reference: VRP | Origin: VRP}
}
\value{
This function returns a list that includes:
\itemize{
\item{I}{a 3x3 matrix representing the moment of inertia tensor of a head
modeled as a solid cone}
\item{CG}{a 1x3 vector representing the center of gravity position of a head
modeled as a solid cone}
\item{m}{a double that returns the head mass}
}
}
\description{
Calculate the moment of inertia of a head modeled as a solid cone
}
\section{Warning}{

Parallel axis theorem does not apply between two arbitrary points.
One point must be the object's center of gravity.
}

\author{
Christina Harvey
}
