% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token_manual.R
\name{get_manual_token}
\alias{get_manual_token}
\title{Get a manual Azure token}
\usage{
get_manual_token(token, type = "Bearer", tenant = NULL, resource = NULL)
}
\arguments{
\item{token}{A character string containing the access token.}

\item{type}{The token type, usually "Bearer".}

\item{tenant}{Optional tenant ID. If NULL, will be extracted from JWT claims if possible.}

\item{resource}{Optional resource/audience URL or GUID. If NULL, will be extracted from
JWT claims if possible.}
}
\value{
An object of class \code{AzureManualToken}, inheriting from \code{AzureToken}.
}
\description{
Create an Azure token object from a pre-existing access token string. This is useful
when you have obtained a token externally (e.g., via Azure CLI, Python, or another
authentication mechanism) and want to use it with the AzureR ecosystem.
}
\details{
This function creates an \code{\link{AzureManualToken}} object that wraps an externally-obtained
access token. The token object can then be used with packages like \code{AzureGraph},
\code{AzureRMR}, and other AzureR family packages.

If the provided token is a JWT (JSON Web Token), the function will attempt to parse it
to extract metadata like tenant ID, resource, and expiration time. For opaque tokens
or tokens that cannot be parsed, you can provide the \code{tenant} and \code{resource}
parameters manually.
}
\section{Token sources}{

Common ways to obtain tokens externally include:
\itemize{
\item Azure CLI: \code{az account get-access-token --resource <resource>}
\item Azure PowerShell: \code{Get-AzAccessToken -ResourceUrl <resource>}
\item Python (azure-identity): \code{DefaultAzureCredential().get_token(<scope>)}
\item MSAL libraries in various languages
}
}

\section{Limitations}{

Manual tokens have the following limitations compared to tokens obtained via
\code{\link{get_azure_token}}:
\itemize{
\item Cannot be automatically refreshed when they expire
\item Are not cached to disk
\item May have incomplete metadata if JWT parsing fails
}
}

\examples{
\dontrun{
# Example: Use a token from Azure CLI
# First, get the token from command line:
# az account get-access-token --resource https://graph.microsoft.com --query accessToken -o tsv

raw_token <- "eyJ0eXAiOiJKV1QiLC..."
token <- get_manual_token(raw_token)

# Check token properties
print(token)
token$validate()

# Use with AzureGraph
library(AzureGraph)
gr <- ms_graph$new(token = token)

# For opaque tokens, provide metadata explicitly
token2 <- get_manual_token(
    token = "opaque_token_string",
    tenant = "your-tenant-id",
    resource = "https://management.azure.com/"
)
}

}
\seealso{
\code{\link{AzureManualToken}}, \code{\link{get_azure_token}}, \code{\link{decode_jwt}}
}
