% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/container.R
\name{get_cosmos_container}
\alias{get_cosmos_container}
\alias{cosmos_container}
\alias{get_cosmos_container.cosmos_database}
\alias{get_cosmos_container.cosmos_endpoint}
\alias{create_cosmos_container}
\alias{create_cosmos_container.cosmos_database}
\alias{delete_cosmos_container}
\alias{delete_cosmos_container.cosmos_database}
\alias{delete_cosmos_container.cosmos_container}
\alias{list_cosmos_containers}
\alias{list_cosmos_containers.cosmos_database}
\title{Methods for working with Azure Cosmos DB containers}
\usage{
get_cosmos_container(object, ...)

\method{get_cosmos_container}{cosmos_database}(object, container, ...)

\method{get_cosmos_container}{cosmos_endpoint}(object, database, container, ...)

create_cosmos_container(object, ...)

\method{create_cosmos_container}{cosmos_database}(
  object,
  container,
  partition_key,
  partition_version = 2,
  autoscale_maxRUs = NULL,
  manual_RUs = NULL,
  headers = list(),
  ...
)

delete_cosmos_container(object, ...)

\method{delete_cosmos_container}{cosmos_database}(object, container, confirm = TRUE, ...)

\method{delete_cosmos_container}{cosmos_container}(object, ...)

list_cosmos_containers(object, ...)

\method{list_cosmos_containers}{cosmos_database}(object, ...)
}
\arguments{
\item{object}{A Cosmos DB database object, as obtained from \code{get_cosmos_database} or \code{create_cosmos_database}, or for \code{delete_cosmos_container.cosmos_container}, the container object.}

\item{container}{The name of the container.}

\item{database}{For \code{get_cosmos_container.cosmos_endpoint}, the name of the database that includes the container.}

\item{partition_key}{For \code{create_cosmos_container}, the name of the partition key.}

\item{partition_version}{For \code{create_cosmos_container}, the partition version. Can be either 1 or 2. Version 2 supports large partition key values (longer than 100 bytes) but requires API version \code{2018-12-31} or later. Use version 1 if the container needs to be accessible to older Cosmos DB SDKs.}

\item{autoscale_maxRUs, manual_RUs}{For \code{create_cosmos_container}, optional parameters for the maximum request units (RUs) allowed. See the Cosmos DB documentation for more details.}

\item{headers, ...}{Optional arguments passed to lower-level functions.}

\item{confirm}{For \code{delete_cosmos_container}, whether to ask for confirmation before deleting.}
}
\value{
For \code{get_cosmos_container} and \code{create_cosmos_container}, an object of class \verb{cosmos_container. For }list_cosmos_container`, a list of such objects.
}
\description{
Methods for working with Azure Cosmos DB containers
}
\details{
These are methods for working with Cosmos DB containers using the core (SQL) API. A container is analogous to a table in SQL, or a collection in MongoDB.

\code{get_cosmos_container}, \code{create_cosmos_container}, \code{delete_cosmos_container} and \code{list_cosmos_containers} provide basic container management functionality.

\code{get_partition_key} returns the name of the partition key column in the container, and \code{list_partition_key_values} returns all the distinct values for this column. These are useful when working with queries that have to be mapped across partitions.
}
\examples{
\dontrun{

endp <- cosmos_endpoint("https://myaccount.documents.azure.com:443/", key="mykey")
db <- get_cosmos_database(endp, "mydatabase")

create_cosmos_container(db, "mycontainer", partition_key="sex")

list_cosmos_containers(db)

cont <- get_cosmos_container(db, "mycontainer")

delete_cosmos_container(cont)

}
}
\seealso{
\link{cosmos_container}, \link{query_documents}, \link{bulk_import}, \link{bulk_delete}
}
