% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.R
\name{MPredict}
\alias{MPredict}
\title{Classify a set of new observation points}
\usage{
MPredict(M, Fit)
}
\arguments{
\item{M}{A matrix of new observations where one row is one observation}

\item{Fit}{A BEST object}
}
\value{
The predicted class
}
\description{
Classify a set of new observation points
}
\examples{
n <- 500
Data <- BESTree::Data[1:n,]
d <- ncol(Data)-1
NewPoints <- BESTree::Data[(n+1):(n+11),1:d]
VA <- ForgeVA(d,1,0,0,0)
Size <- 50
Fit <- BESTree::BEST(Data,Size,VA)
Predictions <- BESTree::MPredict(NewPoints,Fit)
}
