% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InLabs.R
\name{InLabs}
\alias{InLabs}
\alias{AddInLabs}
\alias{RemoveInLabs}
\title{Add or remove input labels in a problem}
\usage{
AddInLabs(ThisProblem, InLabName, DoCheck = TRUE)

RemoveInLabs(ThisProblem, InLabToRemove, DoCheck = TRUE)
}
\arguments{
\item{ThisProblem}{A list object with a structure like that returned by
`BlankProblem()`.}

\item{InLabName}{A character vector with the name(s) of the new input
label(s).}

\item{DoCheck}{A logical value indicating whether checks should be performed
on the incoming and outgoing problem objects. Defaults to `TRUE`, as you
usually want to make sure something isn't awry, but the value is often set
to `FALSE` when used internally (like in DefineProblem) so the problem is
only checked once at the end.}

\item{InLabToRemove}{A character vector with names or indices of the input
label(s) to remove from `ThisProblem`.}
}
\value{
`ThisProblem`, with the edited input labels.
}
\description{
Add or remove input labels in a problem
}
\examples{
my_new_problem = carbonate_system_problem
print(carbonate_system_problem$InLabName) # ID only

my_new_problem = AddInLabs(ThisProblem = my_new_problem, InLabName = "ID2")
my_new_problem = RemoveInLabs(my_new_problem, InLabToRemove = "ID")

print(my_new_problem$InLabName) # ID2 only

}
\seealso{
Other problem manipulation functions: 
\code{\link{BlankProblem}()},
\code{\link{Components}},
\code{\link{CriticalValues}},
\code{\link{InVars}},
\code{\link{MassCompartments}},
\code{\link{Phases}},
\code{\link{SpecialDefs}},
\code{\link{Species}}
}
\concept{problem manipulation functions}
