% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMRMM.R
\name{BMRMM}
\alias{BMRMM}
\title{Bayesian Markov Renewal Mixed Models (BMRMMs)}
\usage{
BMRMM(
  data,
  num.cov,
  cov.labels = NULL,
  state.labels = NULL,
  random.effect = TRUE,
  fixed.effect = TRUE,
  trans.cov.index = 1:num.cov,
  duration.cov.index = 1:num.cov,
  duration.distr = NULL,
  duration.incl.prev.state = TRUE,
  simsize = 10000,
  burnin = simsize/2
)
}
\arguments{
\item{data}{a data frame containing -- individual ID, covariate values, previous state, current state, duration times (if applicable), in that order.}

\item{num.cov}{total number of covariates provided in \code{data}.}

\item{cov.labels}{a list of vectors giving names of the covariate levels. Default is a list of numerical vectors.}

\item{state.labels}{a vector giving names of the states. Default is a numerical vector.}

\item{random.effect}{\code{TRUE} if population-level effects are considered. Default is \code{TRUE}.}

\item{fixed.effect}{\code{TRUE} if individual-level effects are considered. Default is \code{TRUE}.}

\item{trans.cov.index}{a numeric vector indicating the indices of covariates that are used for transition probabilities. Default is all of the covariates.}

\item{duration.cov.index}{a numeric vector indicating the indices of covariates that are used for duration times. Default is all of the covariates.}

\item{duration.distr}{a list of arguments indicating the distribution of duration times. Default is \code{NULL}, which is ignoring duration times.}

\item{duration.incl.prev.state}{\code{TRUE} if the previous state is included in the inference of duration times. Default is \code{TRUE}.}

\item{simsize}{total number of MCMC iterations. Default is 10000.}

\item{burnin}{number of burn-ins for the MCMC iterations. Default is \code{simsize}/2.}
}
\value{
An object of class \code{BMRMM} consisting of \code{results.trans} and \code{results.duration} if duration times are analyzed as a continuous variable. \cr

The field \code{results.trans} is a data frame giving the inference results of transition probabilities.
\tabular{ll}{
\code{covs} \tab covariates levels for each row of the data. \cr
\code{dpreds} \tab maximum level for each related covariate. \cr
\code{MCMCparams} \tab MCMC parameters including simsize, burnin and thinning factor. \cr
\code{tp.exgns.post.mean}\tab posterior mean of transition probabilities for different combinations of covariates. \cr
\code{tp.exgns.post.std} \tab posterior standard deviation of transition probabilities for different combinations of covariates.  \cr
\code{tp.anmls.post.mean} \tab  posterior mean of transition probabilities for different individuals. \cr
\code{tp.anmls.post.std} \tab  posterior standard deviation of transition probabilities for different individuals. \cr
\code{tp.all.post.mean} \tab  posterior mean of transition probabilities for different combinations of covariates AND different individuals. \cr
\code{tp.exgns.diffs.store} \tab  difference in posterior mean of transition probabilities for every pair of covariate levels given levels of the other covariates. \cr
\code{tp.exgns.all.itns} \tab population-level transition probabilities for every MCMC iteration. \cr
\code{clusters} \tab number of clusters for each covariate for each MCMC iteration. \cr
\code{cluster_labels} \tab the labels of the clusters for each covariate for each MCMC iteration. \cr
\code{type} \tab a string identifier for results, which is "Transition Probabilities". \cr
\code{cov.labels} \tab a list of string vectors giving labels of covariate levels. \cr
\code{state.labels} \tab a list of strings giving labels of states. \cr
}
The field \code{results.duration} is a data frame giving the inference results of duration times.
\tabular{ll}{
\code{covs} \tab covariates related to duration times.\cr
\code{dpreds} \tab maximum level for each related covariate.\cr
\code{MCMCparams} \tab MCMC parameters: simsize, burnin and thinning factor.\cr
\code{duration.times} \tab  duration times from the data set.\cr
\code{comp.assignment} \tab mixture component assignment for each data point in the last MCMC iteration.\cr
\code{duration.exgns.store} \tab posterior mean of mixture probabilities for different combinations of covariates of each MCMC iteration.\cr
\code{marginal.prob} \tab estimated marginal mixture probabilities for each MCMC iteration.\cr
\code{shape.samples} \tab estimated shape parameters for gamma mixtures for each MCMC iteration.\cr
\code{rate.samples} \tab estimated rate parameters for gamma mixtures for each MCMC iteration.\cr
\code{clusters} \tab number of clusters for each covariate for each MCMC iteration.\cr
\code{cluster_labels} \tab the labels of the clusters for each covariate for each MCMC iteration.\cr
\code{type} \tab a string identifier for results, which is "Duration Times".\cr
\code{cov.labels} \tab a list of string vectors giving labels of covariate levels. \cr
}
}
\description{
Provides inference results of both transition probabilities and duration times using BMRMMs.
}
\details{
Users have the option to ignore duration times or model duration times as
a discrete or continuous variable via defining \code{duration.distr}.

\code{duration.distr} can be one of the following: \cr
\itemize{
\item \code{NULL}: duration times are ignored. This is the default setting.
\item \code{list('mixgamma', shape, rate)}: duration times are modeled as a mixture gamma variable. \code{shape} and \code{rate}
must be numeric vectors of the same length. The length indicates the number of mixture components.
\item \code{list('mixDirichlet', unit)}: duration times are modeled as a new state with discretization \code{unit}. The duration
state is then analyzed along with the original states. For example, if an duration time entry is 20 and \code{unit} is 5,
then the model will add 4 consecutive new states. If an duration time entry is 23.33 and \code{unit} is 5, then the model
will still add 4 consecutive new states as the blocks are calculated with the floor operation.
}
}
\examples{

# In the examples, we use a shorted version of the foxp2 dataset, foxp2sm

# ignores duration times and only models transition probabilities using all three covariates
results <- BMRMM(foxp2sm, num.cov = 2, simsize = 50)

# models duration times as a continuous variable with 3 gamma mixture components,
results <- BMRMM(foxp2sm, num.cov = 2, simsize = 50,
                 duration.distr = list('mixgamma', shape = rep(1,3), rate = rep(1,3)))

# models duration times as a discrete state with discretization 0.025 and
results <- BMRMM(foxp2sm, num.cov = 2, simsize = 50, 
                 duration.distr = list('mixDirichlet', unit = 0.025))


}
\author{
Yutong Wu, \email{yutong.wu@utexas.edu}
}
