% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{density.bma}
\alias{density.bma}
\alias{density.zlm}
\title{Coefficient Marginal Posterior Densities}
\usage{
\method{density}{bma}(
  x,
  reg = NULL,
  addons = "lemsz",
  std.coefs = FALSE,
  n = 300,
  plot = TRUE,
  hnbsteps = 30,
  addons.lwd = 1.5,
  ...
)
}
\arguments{
\item{x}{A bma object (see \code{\link{bms}}) or a \code{\link{zlm}} object.}

\item{reg}{A scalar integer or character detailing which covariate's
coefficient should be plotted. If \code{reg=NULL} (default), then all
regressors are plotted one after the other, waiting for user interaction.}

\item{addons}{character. Specifies which additional information should be
added to the plot via low-level commands (see 'Details' below).}

\item{std.coefs}{logical. If \code{TRUE} then the posterior density is
estimated for standardized coefficients (representing the case where all
variables have mean zero and standard deviation 1) - default is
\code{FALSE}.}

\item{n}{numeric. the number of equally spaced points at which the density
is to be estimated.}

\item{plot}{logical.  If \code{TRUE} (default), the density is plotted; if
\code{FALSE} then \code{density.bma} only returns the estimated posterior
densities without plotting.}

\item{hnbsteps}{even integer, default 30. The number of numerical
integration steps to be used in case of a hyper-g prior (cf. argument
\code{g} in \code{\link{bms}}). Increase this number to increase accuracy.}

\item{addons.lwd}{scalar, default 1.5. Line width to be used for the
low-level plotting commands specified by \code{addons}. Cf. argument
\code{lwd} in \code{\link{par}}}

\item{\dots}{Additional arguments for \code{\link{plot.default}} with
sensible defaults}
}
\value{
The function returns a list containing objects of the class
\code{\link{density}} detailing the marginal posterior densities for each
coefficient provided in \code{reg}.\cr In case of \code{density.zlm}, simple
marginal posterior coefficient densities are computed, while
\code{density.bma} calculates there mixtures over models according to
posterior model probabilities.\cr These densities contain only the density
points apart from the origin. (see 'Note' below)

As long as \code{plot=TRUE}, the densities are plotted too.  Note that (for
\code{density.bma}) if the posterior inclusion probability of a covariate is
zero, then it will not be plotted, and the returned density will be
\code{list(x=numeric(n),y=numeric(n))}.
}
\description{
Calculates the mixture marginal posterior densities for the coefficients
from a BMA object and plots them
}
\details{
The argument \code{addons} specifies what additional information should be
added to the plot(s) via the low-level commands \code{\link{lines}} and
\code{\link{legend}}:\cr \code{"e"} for the posterior expected value (EV) of
coefficients conditional on inclusion (see argument \code{exact=TRUE} in
\code{\link{coef.bma}}),\cr \code{"s"} for 2 times posterior standard
deviation (SD) bounds,\cr \code{"m"} for the posterior median,\cr \code{"b"}
for posterior expected values of the individual models whom the density is
averaged over,\cr \code{"E"} for posterior EV under MCMC frequencies (see
argument \code{exact=FALSE} in \code{\link{coef.bma}}),\cr \code{"S"} for
the corresponding SD bounds (MCMC),\cr \code{"p"} for plotting the Posterior
Inclusion Probability above the density plot,\cr \code{"l"} for including a
\code{\link{legend}}, \code{"z"} for a zero line, \code{"g"} for adding a
\code{\link{grid}}

Any combination of these letters will give the desired result. Use
\code{addons=""} for not using any of these.\cr In case of
\code{density.zlm}, only the letters \code{e}, \code{s}, \code{l}, \code{z},
and \code{g} will have an effect.
}
\note{
The computed marginal posterior densities from \code{density.bma} are
a Bayesian Model Averaging mixture of the marginal posterior densities of
the individual models.  The accuracy of the result therefore depends on the
number of 'best' models contained in \code{x} (cf. argument \code{nmodel} in
\code{\link{bms}}).

The marginal posterior density can be interpreted as 'conditional on
inclusion': If the posterior inclusion probability of a variable is smaller
than one, then some of its posterior density is Dirac at zero.  Therefore
the integral of the returned density vector adds up to the posterior
inclusion probability, i.e. the probability that the coefficient is not
zero.

Correspondingly, the posterior EV and SD specified by \code{addons="es"} are
based on 'best' model likelihoods ('exact') and are conditional on
inclusion.  They correspond to the results from command
\code{coef.bma(x,exact=TRUE,condi.coef=TRUE,order.by.pip=FALSE)} (cf. the
example below).

The low-level commands enacted by the argument \code{addons} rely on colors
of the \code{\link{palette}}: color 2 for \code{"e"} and \code{"s"}, color 3
for \code{"m"}, color 8 for \code{"b"}, color 4 for \code{"E"} and
\code{"S"}. The default colors may be changed by a call to
\code{\link{palette}}.

Up to BMS version 0.3.0, \code{density.bma} may only cope with built-in
\code{gprior}s, not with any user-defined priors.
}
\examples{


 data(datafls)
 mm=bms(datafls)

 density(mm,reg="SubSahara")
 density(mm,reg=7,addons="lbz") 
 density(mm,1:9)
 density(mm,reg=2,addons="zgSE",addons.lwd=2,std.coefs=TRUE)

# plot the posterior density only for the very best model
 density(mm[1],reg=1,addons="esz")


#using the calculated density for other purposes...
 dd=density(mm,reg="SubSahara")
 plot(dd) 

 dd_list=density(mm,reg=1:3,plot=FALSE,n=400)
 plot(dd_list[[1]])


#Note that the shown density is only the part that is not zero
 dd=density(mm,reg="Abslat",addons="esl")
 pip_Abslat=sum(dd$y)*diff(dd$x)[1]

 #this pip and the EV conform to what is done by the follwing command
 coef(mm,exact=TRUE,condi.coef=TRUE)["Abslat",]

}
\seealso{
\code{\link{quantile.coef.density}} for extracting quantiles,
\code{\link{coef.bma}} for similar concepts, \code{\link{bms}} for creating
bma objects

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{aplot}
\keyword{utilities}
