% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcost_expected.R
\name{bcost_expected}
\alias{bcost_expected}
\title{Expected Overall Costs in Binomial RDT Design}
\usage{
bcost_expected(Cf, Cv, n, G, Cw, N, c, pi)
}
\arguments{
\item{Cf}{Fixed costs of RDT}

\item{Cv}{Variable unit costs of RDT}

\item{n}{RDT sample size}

\item{G}{Reliabilty growth cost}

\item{Cw}{Average cost per warranty claim}

\item{N}{Sales volume}

\item{c}{Maximum allowable failures}

\item{pi}{Failure probability}
}
\value{
Overall expected cost
}
\description{
Define the cost function of expected overall cost including the RDT cost, expected reliabiltiy growth (RG) cost and expected warranty services (WS) cost (for binomial RDT design).
}
\examples{
pi <- pi_MCSim_beta(M = 1000, seed = 10, a = 1, b = 1)
bcost_expected(Cf = 10, Cv = 10, n = 10, G = 100000, Cw = 10, N = 1, c = 1, pi = pi)
}
\seealso{
\code{\link{bcost_RDT}}, \code{\link{bcost_RG}}, \code{\link{bcost_WS}}
}
