% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_scheme.R
\name{exponentiatedOrnsteinUhlenbeck}
\alias{exponentiatedOrnsteinUhlenbeck}
\title{Simulate an exponentiated OU volatility process}
\usage{
exponentiatedOrnsteinUhlenbeck(N, n, T, theta, beta)
}
\arguments{
\item{N}{positive integer determining the number of terms in the Riemman sum element of the
hybrid scheme calculation. Should be of order at least \code{n}.}

\item{n}{positive integer indicating the number of observations per unit of time. It represents the fineness or frequency of observations.}

\item{T}{the time interval to simulate the BSS process over.}

\item{theta}{positive number giving the mean reversion rate of the OU process.}

\item{beta}{the factor in the exponential.}
}
\value{
The function returns a vector of length \code{N + n*T + 1}
}
\description{
\code{exponentiatedOrnsteinUhlenbeck} simulates an exponentiated Ornstein-Uhlenbeckprocess of the correct length to
be used as the volatility process within the hybrid scheme.
}
\examples{

N <- 10000
n <- 100
T <- 1.0
theta <- 0.5
beta <- 0.125

vol <- exponentiatedOrnsteinUhlenbeck(N, n, T, theta, beta)

}
