% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bss_fit.R
\name{gammaKernelBSSFit}
\alias{gammaKernelBSSFit}
\title{Fitting gamma kernel Brownian semistationary processes}
\usage{
gammaKernelBSSFit(Y, n, num_lags = 10)
}
\arguments{
\item{Y}{a vector of observations of a BSS process at frequency \code{n}.}

\item{n}{positive integer indicating the number of observations per unit of time.}

\item{num_lags}{the number of lags to be used in the regression. The default is to use the first 10 lags.}
}
\value{
The function returns a list containing the parameters \code{alpha} and \code{lambda}, and also the mean square
error \code{mse} of the least squares fit. This can be used to compare model fit when trying different kernels.
}
\description{
\code{gammaKernelBSSFit} uses a method of moments to fit the parameters of a gamma kernel Brownian semistationary process
to a vector of observations. A least squares estimate of the parameters is obtained
by minimising the mean square error between the true gamma kernel autocorrelation function and the
empirical ACF of the data, using lags 0,...,H. The number of lags \code{num_lags} used can be adjusted.
The volatility process does not need to be specified.
}
\examples{

N <- 10000
n <- 100
T <- 1.0
theta <- 0.5
beta <- 0.125

kappa <- 3
alpha <- -0.2
lambda <- 1.0


vol <- exponentiatedOrnsteinUhlenbeck(N, n, T, theta, beta)
bss_simulation <- gammaKernelBSS(N, n, T, kappa, alpha, lambda, sigma = vol)
y <- bss_simulation$bss

gammaKernelBSSFit(y, n, num_lags = 10)


}
