% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\name{arguments.loglik}
\alias{arguments.loglik}
\title{Shared documentation for log-likelihood}
\arguments{
\item{m}{a non-negative integer indicating the starting time for the sum of
the partial log-likelihood, given by \eqn{\ell = \sum_{t = m+1}^n \ell_t}
(extract and fit only). Default is \code{m = 0}. For details, see the Section
\link[=arguments.loglik]{The log-likelihood}.}

\item{llk}{logical; indicates whether the value of the log-likelihood
function should be returned (extract and fit only). Default is \code{llk =
  TRUE}.}

\item{sco}{logical; indicates whether the score vector should be returned
(extract and fit only). Default is \code{sco = FALSE}.}

\item{info}{logical; indicates whether the information matrix should be
returned (extract and fit only). Default is \code{info = FALSE}. For the fitting
function, \code{info} is automatically set to \code{TRUE} when \code{report = TRUE}.}

\item{extra}{logical, if \code{TRUE} the matrices and vectors used to calculate
the score vector and the information matrix are returned (extract and fit
only). Default is \code{extra = FALSE}. Ignored by BARC models.}
}
\description{
This is the common documentation for arguments related the log-likelihood
functions, score vector and information matrix for BTSR models.
}
\section{The log-likelihood}{
Let \eqn{\boldsymbol\gamma = (\boldsymbol \rho', \boldsymbol \lambda')'} be
the vector of unknown parameters in the model where
\itemize{
\item \eqn{\boldsymbol\rho} is the vector of unknown parameters in part 1
\item \eqn{\boldsymbol\lambda} is the vector of unknown parameters in part 2.
}
The \strong{log-likelihood function}, conditioned on a set of initial conditions
\eqn{\mathcal{F}_m} is given by
\deqn{
\ell(\boldsymbol\gamma) = \sum_{t = m+1}^n \ell_t =
 \displaystyle\sum_{t=m+1}^n\log\!\big(f(Y_t \mid \mathcal{F}_{t-1},
 \boldsymbol{\gamma})\big).
}

For simplicity of notation assume \eqn{m = 0}. The \strong{score vector}
\eqn{U(\boldsymbol\gamma) = \big(U_{\boldsymbol\rho}(\boldsymbol\gamma)',
U_{\boldsymbol\lambda}(\boldsymbol\gamma)'\big)'}
can be written as
\deqn{
U_{\boldsymbol\rho}(\boldsymbol\gamma) = D_{\boldsymbol\rho}' T_1\boldsymbol h_1 +
M_{\boldsymbol\rho}' T_2\boldsymbol h_2  \qquad \mbox{and} \qquad
U_{\boldsymbol\lambda}(\boldsymbol\gamma) = D_{\boldsymbol\lambda}' T_2\boldsymbol h_2,
}
where
\itemize{
\item \eqn{D_{\boldsymbol\rho}}, \eqn{D_{\boldsymbol\lambda}} and
\eqn{M_{\boldsymbol\rho}} are the matrices for which the \eqn{(i,j)}th
elements are given, respectively, by
\deqn{
  [D_{\boldsymbol\rho}]_{i,j} = \dfrac{\partial \eta_{1i}}{\partial \rho_j},
  \quad
  [D_{\boldsymbol\lambda}]_{i,j} =\dfrac{\partial \eta_{2i}}{\partial \lambda_j}
  \quad \mbox{and} \quad
  [M_{\boldsymbol\rho}]_{i,j} = \dfrac{\partial \eta_{2i}}{\partial \rho_j},
}

\item \eqn{T_1} and \eqn{T_2} are diagonal matrices given by
\deqn{
T_1 = \mathrm{diag}\bigg\{\dfrac{\partial \mu_1}{\partial \eta_{1t}},\dots,
\dfrac{\partial \mu_n}{\partial \eta_{1n}}\bigg\},
\quad
T_2 = \mathrm{diag}\bigg\{\dfrac{\partial \nu_1}{\partial \eta_{2t}},\dots,
\dfrac{\partial \nu_n}{\partial \eta_{2n}}\bigg\},
}

\item \eqn{\boldsymbol{h}_1} and \eqn{\boldsymbol{h}_2} are the vectors
defined by
\deqn{
 \boldsymbol{h}_1 = \bigg(\dfrac{\partial \ell_1}{\partial \mu_1}, \cdots,
 \dfrac{\partial \ell_n}{\partial \mu_n}\bigg)' \quad \mbox{and} \quad
 \boldsymbol{h}_2 = \bigg(\dfrac{\partial \ell_1}{\partial \nu_1}, \cdots,
 \dfrac{\partial \ell_n}{\partial \nu_n}\bigg)'.
}
}
For the models implemented so far, \eqn{\partial\eta_{1t}/\partial\lambda_j =
0} so that we don't need a matrix for these derivatives.

The \strong{conditional Fisher information matrix} for
\eqn{\boldsymbol\gamma} is given by
\deqn{
K_n(\boldsymbol\gamma) =
\begin{pmatrix}
K_{\boldsymbol\rho,\boldsymbol\rho} & K_{\boldsymbol\rho,\boldsymbol\lambda}\\
K_{\boldsymbol\lambda,\boldsymbol\rho}& K_{\boldsymbol\lambda,\boldsymbol\lambda}
\end{pmatrix}
}
with
\deqn{
\begin{aligned}
K_{\boldsymbol\rho,\boldsymbol\rho} &=
 D'_{\boldsymbol \rho}T_1E_\mu T_1 D_{\boldsymbol \rho}
 + M'_{\boldsymbol \rho}T_2E_{\mu\nu}T_1 D_{\boldsymbol \rho}
 + D'_{\boldsymbol \rho}T_1E_{\mu\nu} T_2 M_{\boldsymbol \rho}
 + M'_{\boldsymbol \rho}T_2 E_\nu T_2 M_{\boldsymbol \rho}\\
K_{\boldsymbol\rho,\boldsymbol\lambda} &= K_{\boldsymbol\lambda,\boldsymbol\rho}'=
 D_{\boldsymbol \rho}' T_1E_{\mu\nu}T_2D_{\boldsymbol \lambda}
 + M_{\boldsymbol \rho}' T_2 E_\nu T_2  D_{\boldsymbol \lambda},\\
K_{\boldsymbol\lambda,\boldsymbol\lambda} &=
 D_{\boldsymbol \lambda}' T_2E_\nu T_2D_{\boldsymbol \lambda}
\end{aligned}
}
where \eqn{E_\mu}, \eqn{E_{\mu\nu}} and  \eqn{E_\nu}
are diagonal matrices for which the \eqn{(t,t)}th element is given by
\deqn{
[E_\mu ]_{t,t} =
-\mathbb{E}\bigg(\dfrac{\partial^2 \ell_t}{\partial \mu_t^2} \bigg|
\mathcal{F} _{t-1} \bigg), \quad
[E_{\mu\nu}]_{t,t} =
-\mathbb{E}\bigg(\dfrac{\partial^2 \ell_t}{\partial\mu_t\partial \nu_t}
\bigg| \mathcal{F} _{t-1} \bigg) \quad \mbox{and} \quad
[E_\nu]_{t,t} =
- \mathbb{E}\bigg(\dfrac{\partial^2 \ell_t}{ \partial \nu_t^2} \bigg|
\mathcal{F} _{t-1} \bigg).
}
}

