% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVAR-package.R
\docType{package}
\name{BVAR-package}
\alias{BVAR}
\alias{BVAR-package}
\title{BVAR: Hierarchical Bayesian vector autoregression}
\description{
Estimation of hierarchical Bayesian vector autoregressive models following
Kuschnig & Vashold (2021).
Implements hierarchical prior selection for conjugate priors in the fashion
of Giannone, Lenza & Primiceri (2015) <doi:10.1162/REST_a_00483>. Functions
to compute and identify impulse responses, calculate forecasts,
forecast error variance decompositions and scenarios are available.
Several methods to print, plot and summarise results facilitate analysis.
}
\references{
Giannone, D. and Lenza, M. and Primiceri, G. E. (2015) Prior Selection for
  Vector Autoregressions. \emph{The Review of Economics and Statistics},
  \bold{97:2}, 436-451, \doi{10.1162/REST_a_00483}.

  Kuschnig, N. and Vashold, L. (2021) BVAR: Bayesian Vector Autoregressions
  with Hierarchical Prior Selection in R.
  \emph{Journal of Statistical Software}, \bold{14}, 1-27,
  \doi{10.18637/jss.v100.i14}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/nk027/bvar}
  \item Report bugs at \url{https://github.com/nk027/bvar/issues}
}

}
\author{
\strong{Maintainer}: Nikolas Kuschnig \email{nikolas.kuschnig@wu.ac.at} (\href{https://orcid.org/0000-0002-6642-2543}{ORCID})

Authors:
\itemize{
  \item Lukas Vashold (\href{https://orcid.org/0000-0002-3562-3414}{ORCID})
}

Other contributors:
\itemize{
  \item Nirai Tomass [contributor]
  \item Michael McCracken [data contributor]
  \item Serena Ng [data contributor]
}

}
