% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BallMapper.R
\name{color_by_distance_to_reference_points}
\alias{color_by_distance_to_reference_points}
\title{This function will provide a new coloring which is the minimal and average distance of points in the
point cloud to the referece points. The output from this procedure can be used as an alternative coloring in BallMapper.}
\usage{
color_by_distance_to_reference_points(allPoints, refPoints)
}
\arguments{
\item{allPoints}{is a collection of all points in the dataset.}

\item{refPoints}{is a subset of all points. The function will compute the distance of each point from allPoints to referencePoints}
}
\value{
a pair of minimal and average distances. They can be used to color the BallMapper graph.
var <- seq(from=0,to=6.3,by=0.1)
points <- as.data.frame( cbind( sin(var),cos(var) ) )
values <- as.data.frame(sin(var))
l <- BallMapper(points, values, 0.25)
pts <- as.data.frame(points_covered_by_landmarks(l,1))
new_coloring_function <- color_by_distance_to_reference_points( points, pts )
l$coloring <- new_coloring_function[,1]
ColorIgraphPlot(l)
l$coloring <- new_coloring_function[,2]
ColorIgraphPlot(l)
}
\description{
This function will provide a new coloring which is the minimal and average distance of points in the
point cloud to the referece points. The output from this procedure can be used as an alternative coloring in BallMapper.
}
