% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/relations.R
\name{is.fuzzy}
\alias{is.fuzzy}
\alias{is.fuzzy,TidySet-method}
\title{Check if a TidySet is fuzzy.}
\usage{
is.fuzzy(object)

\S4method{is.fuzzy}{TidySet}(object)
}
\arguments{
\item{object}{Object to be coerced or tested.}
}
\value{
A logical value.
}
\description{
Check if there are fuzzy sets. A fuzzy set is a set where the relationship
between elements is given by a probability (or uncertainty).
}
\section{Methods (by class)}{
\itemize{
\item \code{is.fuzzy(TidySet)}: Check if it is fuzzy

}}
\examples{
TS <- tidySet(list(A = letters[1:5], B = letters[2:10]))
is.fuzzy(TS)
}
\seealso{
Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{group_by.TidySet}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
