% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_alg.R
\name{gibbs_alg}
\alias{gibbs_alg}
\title{Gibbs sampler algorithm for simulated scenarios or real datasets}
\usage{
gibbs_alg(
  N,
  w,
  M,
  K,
  Tl,
  cluster,
  alpha,
  sigma2,
  bs = 1000,
  as = 2,
  al = 2,
  bl = 1000,
  a = 2,
  b = 1000,
  alpha0 = 1/100,
  kstar,
  lambda,
  Y,
  d,
  maxIter = 10000
)
}
\arguments{
\item{N}{A scalar representing the number of observations}

\item{w}{A scalar representing the minimum number of points in each interval between two change points}

\item{M}{A scalar representing the number of points available for each observation}

\item{K}{A vector containing the number of change points for each cluster (or its initial values)}

\item{Tl}{A list containing a vector for each cluster determining the change-point positions in each
cluster  (or its initial values)}

\item{cluster}{A vector containing the cluster assignments for the observations (or its initial values)}

\item{alpha}{A list containing a vector for each cluster determining the constant level values
for each interval between change points in each cluster (or its initial values)}

\item{sigma2}{A vector with the variances of observations (or its initial values)}

\item{bs}{The hyperparameter value for the scale parameter in the inverse-gamma prior for the variance
component}

\item{as}{The hyperparameter value for the shape parameter in the inverse-gamma prior for the variance
component}

\item{al}{The hyperparameter value for the shape parameter in the gamma prior for lambda}

\item{bl}{The hyperparameter value for the scale parameter in the gamma prior for lambda}

\item{a}{The hyperparameter value for the shape parameter in the gamma prior for alpha0}

\item{b}{The hyperparameter value for the scale parameter in the gamma prior for alpha0}

\item{alpha0}{A scalar defining the parameter for the Dirichlet process prior
that controls the number of clusters (or its initial values)}

\item{kstar}{A scalar with the number maximum of change points in all clusters}

\item{lambda}{A scalar defining the parameter for the Truncate Poisson distribution
that controls the number of change points (or its initial values)}

\item{Y}{A matrix M x N with the data sequences}

\item{d}{A scalar representing the number of clusters.}

\item{maxIter}{A scalar for the number of iteration to run in the Gibbs sampler}
}
\value{
A list with each component representing the estimates
 for each iteration of the Gibbs sampler for each parameter
}
\description{
Gibbs sampler algorithm for simulated scenarios or real datasets
}
\examples{
\donttest{
data(data)
# initial values for each paramter and each cluster
par.values <- list(K = c(0, 0), Tl = list(50, 50), alpha = list(5, 10))
#cluster assignment for each data sequence
cluster <- kmeans(t(data), 2)$cluster
# variance for each data sequence
sigma2 <- apply(data, 2, var)
res <- gibbs_alg(alpha0 = 1/100, N = 5, w = 10, M = 50, K = par.values$K,
Tl = par.values$Tl, cluster = cluster, alpha = par.values$alpha, sigma2 = sigma2,
bs = 1000, as = 2, al = 2, bl = 1000, a = 2, b = 1000, kstar = 2, lambda = 2,
Y = data, d = 2, maxIter = 10)
}
}
\seealso{
[run_gibbs()]
}
